//=============================================================================
// VisuStella MZ - Options Core
// VisuMZ_1_OptionsCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_OptionsCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.OptionsCore = VisuMZ.OptionsCore || {};
VisuMZ.OptionsCore.version = 1.26;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 1] [Version 1.26] [OptionsCore]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Options_Core_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Options Core plugin revamps the Options Menu Scene in RPG Maker MZ to be
 * more extensive and sustain a larger variety of options. This plugin will add
 * new options to the list in addition to options from other VisuStella MZ
 * plugins provided that they're installed as well. Game devs that are adept
 * with JavaScript are also able to add in their own options to the menu as
 * well.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Revamped Options Menu Scene and layout.
 * * The ability to add in your own Categories and options inside each of the
 *   individual categories.
 * * Newly added options like Master Volume, Window Tone support, and more.
 * * Integrated options added from other VisuStella MZ plugins.
 * * An added Playtest options category that is only available during test play
 *   to help speed up the game debug process.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 1 ------
 *
 * This plugin is a Tier 1 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin adds some new hard-coded features to RPG Maker MZ's functions.
 * The following is a list of them.
 *
 * ---
 *
 * Options Menu Scene
 *
 * - The whole scene is revamped due to all the new additions provided by the
 * Options Core plugin. While basic functions will still work, do not expect
 * everything to integrate into it seamlessly.
 *
 * ---
 *
 * ============================================================================
 * Extra Features
 * ============================================================================
 *
 * There are some extra features found if other VisuStella MZ plugins are found
 * present in the Plugin Manager list. Most of these enable new options for the
 * Options Core to utilize as the code for them to work is found in the newer
 * plugins.
 *
 * ---
 *
 * Many VisuMZ Plugins
 * 
 * - Many VisuMZ plugins have options that become available when installed
 *   together with the Options Core plugin that wouldn't be available normally.
 * 
 * ---
 *
 * ============================================================================
 * Understanding Options
 * ============================================================================
 * 
 * This section is to clarify a few things about the Options Core.
 * 
 * ---
 * 
 * === Global Settings ===
 * 
 * The majority of settings adjusted by the player in the Options menu are
 * global settings. This is the way it is for base RPG Maker MZ without using
 * any plugins and this is the way it will be when using the Options Core.
 * 
 * What does this mean?
 * 
 * This means that if your player changed the Options settings, then loaded up
 * a different save, the Options settings do not revert to the settings from
 * the last time that save was made.
 * 
 * Why is this?
 * 
 * Because that is the industry standard. If the player wants to adjust the
 * BGM volume down to 50% from 100%, that means that when the player loads a
 * save file, the BGM volume does not shoot back up to 100%. Doing that would
 * require the player to adjust the settings multiple times for each save and
 * that just is not user friendly.
 * 
 * Therefore, the majority of the Options Core settings are global for this
 * very reason and are not going to change because of it.
 * 
 * ---
 * 
 * === Exceptions ===
 * 
 * There are a few exceptions to the rule. These exceptions are the three
 * settings that govern the "Window Tone" in the UI section.
 * 
 * This means the values inserted for "Red", "Green", and "Blue" are saved
 * relative to the save file's settings.
 * 
 * Why is this?
 * 
 * That's because RPG Maker MZ's "Change Window Color" event command does the
 * same thing and we have no intentions of altering how it behaves to keep the
 * otherwise-global aspect.
 * 
 * ---
 *
 * ============================================================================
 * Options Category: General
 * ============================================================================
 *
 * The following are the options that have been added to the Options Menu. This
 * is the default "General" category that appears with the plugin parameters.
 * These can be added and/or removed. If a new option has been added through an
 * update, then there's a likelihood of it not appearing due to the plugin
 * parameters not being updated with them.
 *
 * === Exploration ===
 *
 * These options adjust the general exploration aspects of the game.
 *
 * ---
 *
 * Always Dash
 * - A default option that came with RPG Maker MZ.
 * - If ON, then this puts the player character in a constant state of dashing
 *   unless the Dash button is held down.
 *   - OFF: Walks normally. Holding down Dash button will make player dash.
 *   - ON: Dashes normally. Holding down Dash button will make player walk.
 *
 * ---
 *
 * Autosave
 * - Requires: VisuMZ_1_SaveCore
 * - Lets the player choose whether or not they want autosaving in their game.
 *   - OFF: Autosaves are disabled.
 *   - ON: Autosaves are enabled and occur at the set conditions.
 *
 * ---
 *
 * Show Compass
 * - Requires: VisuMZ_4_ProximityCompass
 * - Displays the Proximity Compass in the corner of the screen.
 *   - OFF: Compass is hidden.
 *   - ON: Compass is shown.
 * 
 * ---
 *
 * Compass Size
 * - Requires: VisuMZ_4_ProximityCompass
 * - Changes the size of the compass.
 *   - 50% for Smallest
 *   - 100% for Largest
 * 
 * ---
 * 
 * Show Date & Time
 * - Requires: VisuMZ_2_DateTimeSystem
 * - Displays the Date & Time HUD in the corner of the screen.
 *   - OFF: HUD is hidden.
 *   - ON: HUD is shown.
 * 
 * ---
 *
 * Show Quest Tracker
 * - Requires: VisuMZ_2_QuestSystem
 * - Player can choose if they want the Quest Tracker Window to appear on the
 *   map scene as they explore.
 *   - OFF: Quest Tracker Window does not appear.
 *   - ON: Quest Tracker Window is visible.
 *
 * ---
 *
 * Quest Tracker Position
 * - Requires: VisuMZ_2_QuestSystem
 * - Lets the player decide which half of the screen the Quest Tracker Window
 *   should appear.
 *   - ←: Quest Tracker Window appears on the left.
 *   - →: Quest Tracker Window appears on the right.
 *
 * ---
 *
 * Random Encounters
 * - Sometimes, random encounters can really take away the enjoyment a player
 *   has for the game if it's too frequent. This option lets the player turn
 *   them off or reduce their frequency by half.
 *   - None: No random encounters while this is selected.
 *   - Half: Random encounters occur at half frequency.
 *   - Normal: Random encounters occur at normal frequency.
 *
 * ---
 * 
 * Show Tutorials
 * - Requires: VisuMZ_2_TutorialPanelSys
 * - Allows tutorials to interrupt gameplay in order to teach the player about
 *   whatever new mechanic needs to be done.
 *   - OFF: Tutorials won't turn on but can still be accessed from main menu.
 *   - ON: Tutorials will halt gameplay to teach the player.
 * 
 * ---
 *
 * === Battle ===
 *
 * These options adjust the general battle aspects of the game.
 *
 * ---
 * 
 * Show Battle Animations:
 * - Players might want to turn off or some battle animations for various
 *   reasons. As examples, battle animations may take a toll on some players'
 *   computers while others might find them too distracting.
 *   - OFF: All battle animations are turned off.
 *   - SOME: Animations that aren't part of a skill/item's action sequence will
 *     not be displayed.
 *   - ON: All battle animations are visible.
 * 
 * ---
 *
 * Battle Animation Speed:
 * - Battles can become a slog for some types of players. This option comes
 *   with four speed types to blaze through the battle while animations are
 *   playing. Fret not, if it's time for an actor to input actions, then the
 *   battle speed will temporarily revert to normal speed.
 *   - Normal: The usual battle speed.
 *   - Fast: x2 the usual battle speed.
 *   - Faster: x3 the usual battle speed.
 *   - Fastest: x4 the usual battle speed.
 *
 * ---
 *
 * Battle Camera
 * - Requires: VisuMZ_3_ActSeqCamera
 * - Allows the player to turn on/off the camera in case the player is one
 *   who gets motion sick easily.
 *   - OFF: Battle camera is static and doesn't move/zoom.
 *   - ON: Battle camera has full range of movement and zoom.
 *
 * ---
 *
 * Command Remember
 * - A default Options menu command that remembers the last position of the
 *   battle input window.
 *   - OFF: Cursor position resets each time the battle input window is active.
 *   - ON: Cursor position remembers last position for battle input window.
 *
 * ---
 *
 * Active Battle Style
 * - Requires: VisuMZ_2_BattleSystemATB
 * - Lets the player switch betweent "Wait" and "Active".
 *   - Wait: ATB gauges stop filling up the moment an actor can input.
 *   - Active: ATB gauges keep filling even if actors can input.
 *
 * ---
 *
 * Active Battle Speed
 * - Requires: VisuMZ_2_BattleSystemATB
 * - Lets the player control how fast ATB gauges fill up.
 * - 1 for slowest.
 * - 5 for fastest.
 *
 * ---
 *
 * Auto Battle Start
 * - Requires: VisuMZ_1_BattleCore
 * - Start battles with Auto Battle on/off?
 *   - OFF: Battles do not start with Auto Battle on.
 *   - ON: Battles start with Auto Battle on.
 *
 * ---
 *
 * Auto Battle Style
 * - Requires: VisuMZ_1_BattleCore
 * - Determine if Auto Battle for the player party will attack only or be
 *   allowed to use skills as well.
 *   - Attack: Auto Battle actors will attack only.
 *   - Skills: Auto Battle actors can also use skills.
 * 
 * ---
 *
 * === Screen ===
 *
 * These options adjust the general screen-related aspects of the game.
 *
 * ---
 *
 * Display FPS
 * - Turns on/off the FPS counter in the upper left section of the screen.
 *
 * ---
 * 
 * Limit FPS
 * - Allows player to limit FPS counter. If ON, limit becomes 60. If off, the
 *   FPS counter is uncapped to whatever the player's monitor allows.
 * 
 * ---
 *
 * Full Screen
 * - Switches the game client between windowed mode and full screen.
 *
 * ---
 *
 * Stretch Screen
 * - If the game client is larger than the screen, then the game's canvas will
 *   stretch to fit the client. Turn this on or off.
 *
 * ---
 * 
 * Special Effects
 * - Requires: VisuMZ_2_BrightEffects and/or VisuMZ_2_HorrorEffects
 * - When using VisuStella MZ's Horror Effects or Bright Effects, users can opt
 *   to disable those effects by turning this option on/off.
 * 
 * ---
 * 
 * Dust Clouds
 * - Requires: VisuMZ_2_MovementEffects
 * - Plays dust cloud effects when the player and followers are running across
 *   the screen.
 * 
 * ---
 * 
 * Footprint Marks
 * - Requires: VisuMZ_2_MovementEffects
 * - Puts footprints down on the screen when the character sprites are moving
 *   on the screen.
 * 
 * ---
 * 
 * Smooth Scroll
 * - Requires: VisuMZ_2_MovementEffects
 * - Gradually shifts the screen camera to the player position.
 * 
 * ---
 * 
 * Blinking Lights
 * - Requires: VisuMZ_2_LightingEffects
 * - Turns off blinking effect from lighting effects.
 * 
 * ---
 * 
 * Pulsing Lights
 * - Requires: VisuMZ_2_LightingEffects
 * - Turns off pulsing effect from Lighting effects.
 * 
 * ---
 * 
 * Weather Density
 * - Requires: VisuMZ_2_WeatherEffects
 * - Allows players to control the density of weather patterns if it may be too
 *   much for their devices to handle.
 * 
 * ---
 *
 * === Controls ===
 *
 * These options adjust the keyboard and controller buttons and what functions
 * are assigned to them. The player can use these commands to rebind them.
 * These settings require VisuMZ_0_CoreEngine and for rebindings to be enabled
 * in the Plugin Parameters.
 *
 * ---
 * 
 * Rebind Keyboard
 * - Requires: VisuMZ_0_CoreEngine
 * - Allows players to rebind their keyboard controls.
 * 
 * ---
 * 
 * Rebind Gamepad
 * - Requires: VisuMZ_0_CoreEngine
 * - Allows players to rebind their gameplad controls.
 *   - Gamepad must be connected.
 * 
 * ---
 *
 * ============================================================================
 * Options Category: Audio
 * ============================================================================
 *
 * The following are the options that have been added to the Options Menu. This
 * is the default "Audio" category that appears with the plugin parameters.
 * These can be added and/or removed. If a new option has been added through an
 * update, then there's a likelihood of it not appearing due to the plugin
 * parameters not being updated with them.
 *
 * === Volume ===
 *
 * These options adjust the volume-related aspects of the game.
 *
 * ---
 *
 * Master Volume
 * - The master volume sets the volume of all the other volume types by a
 *   proportional amount from 0% to 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 *
 * ---
 *
 * BGM Volume
 * - Controls the background music volume by a value between 0% and 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 *
 * ---
 *
 * BGS Volume
 * - Controls the background ambience volume by a value between 0% and 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 *
 * ---
 *
 * ME Volume
 * - Controls the fanfare volume by a value between 0% and 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 *
 * ---
 *
 * SE Volume
 * - Controls the sound effect volume by a value between 0% and 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 * 
 * ---
 * 
 * Voice Volume:
 * - Requires: VisuMZ_2_VoiceActControl
 * - Allows players to adjust the volume of the voice audio channel instead of
 *   having it linked to the SE audio channel. This is so players can choose to
 *   turn off sound effects while still hearing voices or vice versa.
 * 
 * ---
 * 
 * Voice Language:
 * - Requires: VisuMZ_2_VoiceActControl & Audio Languages enabled
 * - Allows players switch audio languages spoken by in-game characters.
 * 
 * ---
 * 
 * Advanced Sound Options
 * - Requires: Tome571/TF's "Advanced Sound Options plugin"
 * - Allows for very specialized control over sound settings.
 * - https://tome571.itch.io/advanced-audio-options-rmmz
 * 
 * ---
 *
 * === Sound Effects ===
 *
 * These options adjust the sound effects-related aspects of the game.
 *
 * ---
 * 
 * Battle Voices
 * - Requires: VisuMZ_3_BattleVoices
 * - Allows player to toggle the playing of battle voices in-battle.
 * 
 * ---
 * 
 * Footstep Sounds
 * - Requires: VisuMZ_2_MovementEffects
 * - Plays footstep sounds when the character sprites are moving on screen.
 * 
 * ---
 * 
 * Letter Sounds
 * - Requires VisuMZ_3_MessageSounds
 * - Allows player to toggle the playing of letter sounds for messages.
 * 
 * ---
 *
 * Sound Effects:
 * Cursor SFX:
 * Confirm SFX:
 * Cancel SFX:
 * Buzzer SFX:
 * - Not all sound effects register well with players and/or their computers.
 * - This lets players pick different sound effects if they have trouble
 *   hearing certain ones.
 *
 * ---
 *
 * ============================================================================
 * Options Category: UI
 * ============================================================================
 *
 * The following are the options that have been added to the Options Menu. This
 * is the default "UI" category that appears with the plugin parameters.
 * These can be added and/or removed. If a new option has been added through an
 * update, then there's a likelihood of it not appearing due to the plugin
 * parameters not being updated with them.
 *
 * === Windows ===
 *
 * These options adjust the Windows UI-related aspects of the game.
 *
 * ---
 *
 * Window Tone: Red:
 * Window Tone: Green:
 * Window Tone: Blue:
 * - Allows the player to adjust the Window Tone to their liking. This helps
 *   give players a more personal touch on their save file.
 *
 * ---
 *
 * === Text ===
 *
 * These options adjust the Text-related aspects of the game.
 *
 * ---
 * 
 * Text Language:
 * - Requires: VisuMZ_1_MessageCore & Text Languages to be enabled
 * - Allows the player to switch between different languages in the game.
 * - Languages are set up by the Message Core.
 * 
 * ---
 *
 * Text Font:
 * - Certain fonts are harder to read for different players. Let the players
 *   pick the font the game uses to allow themselves maximum comfort.
 *
 * ---
 *
 * Text Speed
 * - Requires: VisuMZ_1_MessageCore
 * - Allows the player to set the speed at which text displays during messages.
 * - There are speeds 1 through 10, with 1 being the slowest and 10 being the
 *   fastest.
 * - Speed 11 is "Instant" which causes text to display instantly.
 * 
 * ---
 * 
 * Text Effects
 * - Requires: VisuMZ_2_AniMsgTextEffects
 * - Allows the player to toggle animated text effects.
 *
 * ---
 *
 * === Touch Input ===
 *
 * These options adjust the Touch UI-related aspects of the game.
 *
 * ---
 *
 * Touch UI
 * - Requires VisuMZ_0_CoreEngine
 * - This sets the visibility of the UI elements that are touch-only in the
 *   game such as the cancel button and the left/right actor switch buttons.
 *   - OFF: The touch-only UI elements do not appear.
 *   - ON: The touch-only UI elements do appear.
 *
 * ---
 *
 * Button Position:
 * - Requires VisuMZ_0_CoreEngine
 * - Moves the clickable Cancel button, Page Up button, and Page down button
 *   to either the top of the screen or bottom of the screen.
 *
 * ---
 *
 * Hover Select:
 * - Turn on/off Hover Select when using the mouse. If Hover Select is on, then
 *   the window cursor will automatically follow the mouse when applicable.
 *   Otherwise, the player will have to manually move the cursor.
 *
 * ---
 *
 * === Menu Arrangement ===
 *
 * These options adjust the Menu Arrangement-related aspects of the game.
 *
 * ---
 *
 * Menu Style
 * - Switch between 'Recommended' and 'Custom'. Recommended will have the menus
 *   arranged in the way the game/plugins decide for them to be. Otherwise,
 *   the player will be able to customize the positions of these next windows:
 *
 * ---
 *
 * Help Window Position:
 * Input Window Position:
 * - Adjust the positions of these windows in the various positions listed to
 *   allow the player to select what they're most comfortable with.
 *
 * ---
 *
 * === Battle UI ===
 *
 * These options adjust the Battle UI-related aspects of the game.
 *
 * ---
 *
 * Show Provoke Origin
 * - Requires VisuMZ_2_AggroControlSystem
 * - If a battler is under the effects of "Provoke", then a line tracing back
 *   to the origin of the "Provoke" effect can be found.
 *   - OFF: Hide the Provoke Origin lines.
 *   - ON: Show the Provoke Origin lines.
 *
 * ---
 *
 * Show Aggro Gauge
 * - Requires VisuMZ_2_AggroControlSystem
 * - Displays the amount of aggro a party member has with a gauge.
 *   - OFF: The Aggro Gauge is hidden.
 *   - ON: The Aggro Gauge is visible.
 *
 * ---
 *
 * Show HP Gauges
 * - Requires VisuMZ_3_VisualHpGauge
 * - Displays the amount of HP each battler has with a gauge under their feet.
 *   - OFF: The battlefield's HP Gauges are hidden.
 *   - ON: The battlefield's HP Gauges are visible.
 *
 * ---
 *
 * Show ATB Gauges
 * - Requires VisuMZ_2_BattleSystemATB
 * - Displays ATB gauges on each battler showing how much time they have left
 *   before they can act.
 *   - OFF: The battlefield's ATB Gauges are hidden.
 *   - ON: The battlefield's ATB Gauges are hidden.
 *
 * ---
 *
 * ============================================================================
 * Options Category: Playtest
 * ============================================================================
 *
 * The following are the options that have been added to the Options Menu. This
 * is the default "Text" category that appears with the plugin parameters.
 * These can be added and/or removed. If a new option has been added through an
 * update, then there's a likelihood of it not appearing due to the plugin
 * parameters not being updated with them.
 * 
 * *NOTE* Unless changed, this category only appears during playtesting and
 * does not appear outside of playtesting, which means deployed games should
 * not display this unless you've given them access to playtest mode.
 *
 * === Effects ===
 * 
 * ---
 *
 * Playtest Effects:
 * - If this is 'OFF', then all the Playtesting options are turned off. If 'ON'
 *   then you can adjust them however you like.
 *
 * ---
 * 
 * === Exploration ===
 * 
 * These options adjust the Playtest Exploration-related aspects of the game.
 * 
 * ---
 *
 * Map Update Speed:
 * - Allows you to speed up the events and movement on the map with four speed
 *   levels ranging from normal to x3 speed.
 *   - Normal: The usual update speed.
 *   - Fast: x2 the usual update speed.
 *   - Faster: x3 the usual update speed.
 *   - Fastest: x4 the usual update speed.
 *
 * ---
 *
 * Random Encounters:
 * - Sometimes, random encounters can really take away the enjoyment a player
 *   has for the game if it's too frequent. This option lets the player turn
 *   them off or reduce their frequency by half.
 *   - None: No random encounters while this is selected.
 *   - Half: Random encounters occur at half frequency.
 *   - Normal: Random encounters occur at normal frequency.
 *
 * ---
 * 
 * === Battle ===
 * 
 * These options adjust the Playtest Battle-related aspects of the game.
 * 
 * ---
 *
 * God Mode:
 * - If this is ON, then actors will be unable to die even if their HP reaches
 *   0. They will continue to act as if they still have HP left.
 *
 * ---
 *
 * Resist Negative Effects:
 * - Requires VisuMZ_1_SkillsStatesCore.
 * - If ON, this will resist states with a <Negative State> notetag.
 * - If ON, this will also resist debuffs.
 *
 * ---
 *
 * Instant K.O.
 * - If ON, then actors attacking enemies will deal fatal damage to enemies.
 *
 * ---
 *
 * Skill Costs:
 * Consume Items:
 * - If OFF, then skills won't cost anything and items won't be consumed.
 *
 * ---
 * 
 * === Rewards ===
 * 
 * These options adjust the Playtest Rewards-related aspects of the game.
 * 
 * ---
 *
 * EXP Multiplier:
 * Gold Multiplier:
 * Drop Multiplier:
 * - Allows you to adjust the multipliers for EXP gained, Gold gained, and
 *   Drop rates from x2 to x1024.
 *
 * ---
 * 
 * === Spawners ===
 * 
 * These options adjust the Playtest Spawner-related aspects of the game.
 * 
 * ---
 *
 * Spawn Items:
 * Spawn Weapons:
 * Spawn Armors:
 * - Sends you to a "shop" where you can purchase any of the game's named items
 *   for 0 gold each.
 *
 * ---
 * 
 * === Debug ===
 * 
 * These options adjust the Playtest Debug-related aspects of the game.
 * 
 * ---
 *
 * Debug Menu:
 * - Sends you to the Debug Menu Scene.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Options Settings
 * ============================================================================
 *
 * Allows you to adjust some default settings that may affect the way the
 * Options Menu Scene looks and/or some of the options available inside it.
 *
 * ---
 *
 * Categories
 * 
 *   Category Window Style:
 *   - How do you wish to draw commands in the Category Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Category Text Align:
 *   - Text alignment for the Command Window.
 * 
 *   Background Type:
 *   - Select background type for this window.
 *
 * ---
 * 
 * Options Window
 * 
 *   Background Type:
 *   - Select background type for this window.
 * 
 * ---
 *
 * Button Assist Window
 *
 *   Switch Category:
 *   - Button assist text used for switching categories.
 *   - For VisuStella MZ's Core Engine's Button Assist Window.
 * 
 *   Background Type:
 *   - Select background type for this window.
 *   - Requires VisuMZ_0_CoreEngine!
 *
 * ---
 *
 * Sound
 * 
 *   Cursor Sounds:
 *   OK Sounds:
 *   Cancel Sounds:
 *   Buzzer Sounds:
 *   - SE files player can select from for OK SE.
 *   - The first in the list will always be the default SE.
 *
 * ---
 *
 * Text
 * 
 *   Font Options:
 *   - Available fonts for the player to select from.
 *   - The first font in the list is always be the default font.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Options Categories
 * ============================================================================
 *
 * Here, you can add/edit/remove the categories found in the Options Menu Scene
 * and their related Options.
 *
 * ---
 *
 * Options Categories
 * 
 *   Name:
 *   - The name of this category as seen in the Category Window.
 *   - Text codes are supported.
 * 
 *   Icon:
 *   - Icon used for this category.
 *   - Use 0 for no icon.
 * 
 *   JS: Show/Hide:
 *   - Code used to determine if this category is visible.
 * 
 *   Options List:
 *   - Add options to this category here.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Listed Options
 * ============================================================================
 *
 * These are the Options found within an Options Category's List. Add, edit,
 * and/or remove them as you see fit. Adding or altering an option will require
 * adequate knowledge of JavaScript to do so.
 *
 * ---
 *
 * Basic
 * 
 *   Symbol:
 *   - Symbol used for this option when selected.
 *   - Make sure this is unique from other symbols.
 * 
 *   Icon:
 *   - Icon used for this option.
 *   - Use 0 for no icon.
 * 
 *   STR: Text:
 *   - Displayed text used for this option.
 *   - If this has a value, ignore the JS: Text version.
 * 
 *   JS: Text:
 *   - JavaScript code used to determine string used for the displayed name.
 *
 * ---
 *
 * Accessibility
 * 
 *   JS: Show/Hide:
 *   - Code used to determine if this option is visible.
 * 
 *   JS: Enable:
 *   - Code used to determine if this option is enabled.
 *   - This does NOT determine the ON/OFF value of the option. It instead
 *     determines if the option can be changed (enabled) or not (disabled).
 * 
 *   JS: Ext:
 *   - Code used to determine if this option's ext value.
 *
 * ---
 *
 * Functions
 * 
 *   JS: Draw Option:
 *   - Code used to draw this item into the List Window.
 * 
 *   JS: Process OK:
 *   - Code used when OK button is pressed while selected.
 * 
 *   JS: Cursor Right:
 *   - Code used when Right button is pressed while selected.
 * 
 *   JS: Cursor Left:
 *   - Code used when Left button is pressed while selected.
 *
 * ---
 *
 * Data
 * 
 *   JS: Default Value:
 *   - Code used to determine the default value of this option.
 *   - This is what determines the default ON/OFF values of an option.
 * 
 *   JS: Save Option:
 *   - Code used when saving this options setting.
 * 
 *   JS: Load Option:
 *   - Code used when loading this options setting.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Keyboard/Controller Rebind Settings
 * ============================================================================
 *
 * Requires VisuMZ_0_CoreEngine!
 * 
 * These new Options Core menu commands will take the player to new scenes
 * where the players can rebind their keyboard or controller settings. This
 * will require the VisuStella MZ Core Engine in order to work.
 * 
 * ==== Keyboard Limitations ====
 * 
 * Not all keyboard keys are eligible for rebinding. Only a certain set of
 * keys are allowed. They are the following:
 * 
 *   - Numbers on the top row from 1 through 0.
 *   - Tilde (~), Minus (-), Plus/Equals (+/=)
 *   - Keys A through Z
 *   - [ ] \ ; ' < > /
 * 
 * The reason why only these keys are available is to avoid hitting any other
 * system bound keys like the function keys, caps lock, etc. These will also
 * function as a second set of controls with default controls bound to the
 * arrow keys, Enter, Space, Escape, and Numpad. This way, the player cannot
 * softlock themselves out of the key rebinding scene.
 * 
 * ---
 * 
 * ==== Gamepad Limitations ====
 * 
 * Just like the keyboard, not everything on the controller is eligible for
 * rebinding. However, the limitations are much less as the limitations are
 * only forbidden from rebinding the D-Pad. The reason for this is due to how
 * D-Pad actions may be hardcoded for some controllers and are better left
 * alone instead.
 * 
 * Gamepads cannot remove individual keys from bindings like keyboards can.
 * This is because there's no fallback key that would prevent a softlock from
 * happening. Instead, they get a function to reset the controller.
 * 
 * ---
 * 
 * ==== Plugin Parameters ====
 *
 * ---
 *   
 * General Settings:
 *   
 *   Enable Rebinding?:
 *   - Enable keyboard and controller rebinding?
 *   - Requires VisuMZ_0_CoreEngine!
 *   
 *   Keyboard Bindings:
 *   - Select the keys that can be rebound and the order they appear for
 *     keyboard. 
 *   
 *   Gamepad Bindings:
 *   - Select the keys that can be rebound and the order they appear for
 *     gamepad. 
 *   
 *     JS: Reset Gamepad:
 *     - Determine how the gamepad map should be when reset. 
 * 
 * ---
 *   
 * Vocabulary:
 *   
 *   Button Vocab:
 *   
 *     Up:
 *     Left:
 *     Down:
 *     Right:
 *     OK:
 *     Escape:
 *     Cancel:
 *     Menu:
 *     Page Up:
 *     Page Down:
 *     Shift:
 *     Tab:
 *     - Text used to represent this input type. Text codes allowed.
 * 
 *     Button Format:
 *     - Text format for unassigned gamepad buttons.
 *     - Text codes allowed.
 *     - %1 - Button ID.
 *   
 *     D-Pad Format:
 *     - Text format for directional pad buttons.
 *     - Text codes allowed.
 *     - %1 - Direction.
 *   
 *   Button Assist:
 *   
 *     Shift: Remove:
 *     Shift: Reset:
 *     OK: Select:
 *     Cancel: Exit:
 *     - Text used to represent this button assist. 
 *   
 *   Help Descriptions:
 *   
 *     Select for Keyboard:
 *     - Help description used for selecting a keyboard button.
 *     - Text codes allowed.
 *   
 *     Keyboard Instruct:
 *     - Help description used to ask for a key to press.
 *     - Text codes allowed.
 *   
 *     Forbidden Key:
 *     - Help description used when a keyboard key cannot be used.
 *     - Text codes allowed.
 *   
 *     Select for Gamepad:
 *     - Help description used for selecting a gamepad button.
 *     - Text codes allowed.
 *   
 *     Gamepad Instructions:
 *     - Help description used to ask for a gamepad button to press.
 *     - Text codes allowed.
 *   
 *     Forbidden Button:
 *     - Help description used when a gamepad button cannot be reassigned.
 *     - Text codes allowed.
 *   
 *     No Gamepad Detected:
 *     - Help description used when no gamepad is detected.
 *     - Text codes allowed.
 * 
 * ---
 *   
 * Window Settings:
 *   
 *   Window_Help:
 *   
 *     Background Type:
 *     - Select background type for this window. 
 *   
 *   Window_KeyRebinds:
 *   
 *     Background Type:
 *     - Select background type for this window. 
 *   
 *     Key Type Align:
 *     - Text alignment for the key types? 
 *   
 *     Rebind Key Align:
 *     - Text alignment for the rebind key? 
 *   
 *     JS: X, Y, W, H:
 *     - Code used to determine the dimensions for this window. 
 *   
 *   Window_RebindHelp:
 *   
 *     Background Type:
 *     - Select background type for this window. 
 *   
 *     JS: X, Y, W, H:
 *     - Code used to determine the dimensions for this window. 
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Master Volume Shortcut Settings
 * ============================================================================
 *
 * Settings regarding the Master Volume Shortcut keys. Requires the
 * Options Core to allow players to adjust the master volume.
 * 
 * Shortcut: Ctrl + PageUp / Ctrl + PageDn
 *
 * ---
 *
 * Shortcut
 * 
 *   Enabled?:
 *   - Enable the shortcut?
 *   - Shortcut: Ctrl + PageUp / Ctrl + PageDn
 * 
 *   Shortcut Change Value:
 *   - What is the change amount for the shortcut key?
 *   - Master volume caps at 0 and 100.
 *
 * ---
 *
 * Sound Effects > Volume Up
 * 
 *   Filename:
 *   - Filename of the sound effect played.
 * 
 *   Volume:
 *   - Volume of the sound effect played.
 * 
 *   Pitch:
 *   - Pitch of the sound effect played.
 * 
 *   Pan:
 *   - Pan of the sound effect played.
 *
 * ---
 *
 * Sound Effects > Volume Down
 * 
 *   Filename:
 *   - Filename of the sound effect played.
 * 
 *   Volume:
 *   - Volume of the sound effect played.
 * 
 *   Pitch:
 *   - Pitch of the sound effect played.
 * 
 *   Pan:
 *   - Pan of the sound effect played.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.26: July 18, 2024
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** Keyboard and Controller Rebinding added!
 * *** New General Option added: "Limit FPS"
 * **** Allows player to limit FPS counter. If ON, limit becomes 60. If off,
 *      the FPS counter is uncapped to whatever the player's monitor allows.
 * *** New Plugin Parameters added for Keyboard and Controller Rebinding.
 * **** See help file for more information.
 * *** Added Keyboard and Controller Rebinding access to Options menu.
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the "General" plugin parameters found in the Options Category
 *      plugin parameter settings to your current project.
 * 
 * Version 1.25: January 18, 2024
 * * Compatibility Update!
 * ** Added compatibility for Message Core's new Text Language options:
 * ** Added compatibility for Voice Acting Control's Voice Language options:
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the "Audio" and "UI" plugin parameters found in the Options
 *      Category plugin parameter settings to your current project.
 * * Documentation Update!
 * ** Help file updated for new features.
 * 
 * Version 1.24: December 14, 2023
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Date & Time System
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General plugin parameters found in the Options Category
 *      plugin parameter settings to your current project.
 * * Documentation Update!
 * ** Help file updated for new features.
 * 
 * Version 1.23: June 15, 2023
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Voice Acting Control and Battle Voices
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the Audio plugin parameters found in the Options Category
 *      plugin parameter settings to your current project.
 * * Documentation Update!
 * ** Help file updated for new features.
 * 
 * Version 1.22: January 20, 2023
 * * Added compatibility functionality for future plugin:
 * ** Animated Message Text Effects
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the UI plugin parameters found in the Options Category plugin
 *      parameter settings to your current project.
 * 
 * Version 1.21: October 27, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Added compatibility functionality for future plugin:
 * ** Tutorial Panel System
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General and Audio settings found in the Options Category
 *      plugin parameter to your current project.
 * * New Features!
 * ** Added "Master Volume Shortcut" Plugin Parameters.
 * *** Change the master volume anywhere in the game as long as the Options
 *     Core allows players to adjust the Master Volume.
 * *** Shortcut: Ctrl + PageUp / Ctrl + PageDn
 * 
 * Version 1.20: September 15, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Button Assist Window no longer follows the Core Engine's Option Scene
 *    settings, but instead follows the Button Assist Window's settings.
 *    Update made by Arisu.
 * * New Features!
 * ** New Plugin Parameters added by Arisu:
 * *** Parameters > Options Settings > Categories > Background Type
 * *** Parameters > Options Settings > Options Window > Background Type
 * *** Parameters > Options Settings > Button Assist Window > Background Type
 * **** Select background type for this window.
 * 
 * Version 1.19: August 11, 2022
 * * Feature Update!
 * ** VisuMZ Core Engine menu layout window settings now apply to all windows
 *    found in the Options Scene. Update made by Arisu.
 * 
 * Version 1.18: March 3, 2022
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins: "Movement Effects",
 *    "Weather Effects", and "Lighting Effects". Hold on tight!
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General and Audio settings found in the Options Category
 *      plugin parameter to your current project.
 * 
 * Version 1.17: December 30, 2021
 * * Bug Fixes!
 * ** Residual old code is now disabled from appearing on deployed projects if
 *    any carry over config data is brought over from the playtesting phase.
 * ** Yep, again again.
 * ** We had to call in the big boss to fix this.
 * 
 * Version 1.16: December 23, 2021
 * * Bug Fixes!
 * ** Residual old code is now disabled from appearing on deployed projects if
 *    any carry over config data is brought over from the playtesting phase.
 *    Fix made by Arisu.
 * ** Yep, again.
 * 
 * Version 1.15: December 16, 2021
 * * Bug Fixes!
 * ** Residual old code is now disabled from appearing on deployed projects if
 *    any carry over config data is brought over from the playtesting phase.
 *    Fix made by Arisu.
 * 
 * Version 1.14: December 9, 2021
 * * Compatibility Update!
 * ** Full Screen options have been updated to match the newest version of RPG
 *    Maker MZ's NodeJS client. Update made by Olivia.
 * *** The "Full Screen" settings have been updated in General settings. If
 *     you want to acquire these updated settings for an already-existing
 *     project, do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General settings found in the Options Category plugin
 *      parameter to your current project.
 * 
 * Version 1.13: April 23, 2021
 * * Documentation Update!
 * ** Added clarity for some of the JS plugin parameters:
 * *** JS: Enable:
 * **** This does NOT determine the ON/OFF value of the option. It instead
 *      determines if the option can be changed (enabled) or not (disabled).
 * *** JS: Default Value:
 * **** This is what determines the default ON/OFF values of an option.
 * 
 * Version 1.12: April 9, 2021
 * * Bug Fixes!
 * ** Turning Touch UI off should no longer disable the Button Assist Text for
 *    the Page Up/Down buttons from the Core Engine. Fix made by Olivia.
 * 
 * Version 1.11: April 2, 2021
 * * Bug Fixes!
 * ** Default "Special Effects" option added in v1.10 should now have a fixed
 *    load data sequence that does not force open the FPS counter. To acquire
 *    the fixed settings, do either of the following:
 * *** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * *** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General settings found in the Options Category plugin
 *      parameter to your current project.
 * * Documentation Update!
 * ** Added "Understanding Options" section.
 * ** Options Category: General section updated with "Special Effects" which
 *    was left out of the v1.10 update.
 * * Feature Update!
 * ** Default settings will now run regardless of undefined setting provided
 *    that their other conditions for usage have showed up first. This is to
 *    reduce confusion for users. Update made by Yanfly.
 * 
 * Version 1.10: March 12, 2021
 * * Compatibility Update!
 * ** Added compatibility for VisuStella MZ Bright Effects and Horror Effects.
 * *** "Special Effects" option allows users to turn on/off filters applied by
 *     the Bright Effects and Horror Effects plugins.
 * *** The "Special Effects" settings have been added to General settings. If
 *     you want to acquire these settings for an already-existing project, do
 *     either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General settings found in the Options Category plugin
 *      parameter to your current project.
 * * Documentation Update!
 * ** Added Bright Effects and Horror Effects to the list of plugins with Extra
 *    Features. Update made by Olivia.
 * 
 * Version 1.09: January 29, 2021
 * * Compatibility Update
 * ** Added compatibility for Tome571/TF's "Advanced Sound Options plugin".
 * *** Default settings have been added to the Audio settings. If you want to
 *     acquire these settings for an already-existing project, do either of the
 *     following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the Audio settings found in the Options Category plugin
 *      parameter to your current project.
 * 
 * Version 1.08: January 8, 2021
 * * Bug Fixes!
 * ** JS: Enabled accessibility option should now be working properly.
 * * Feature Update!
 * ** Disabled options should now be faded out completely.
 * 
 * Version 1.07: November 15, 2020
 * * Optimization update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.06: November 8, 2020
 * * Feature Update!
 * ** Modern Controls compatibility with Core Engine no longer enables the
 *    Item Categories window and child classes to utilize the Home/End keys.
 *
 * Version 1.05: October 18, 2020
 * * Optimization update!
 * 
 * Version 1.04: September 27, 2020
 * * Compatibility Update!
 * ** This plugin should offer better compatibility for future plugins!
 *    Update made by Yanfly.
 * 
 * Version 1.03: September 20, 2020
 * * Compatibility Update!
 * ** This plugin should offer better compatibility for future plugins!
 *    Update made by Yanfly.
 * 
 * Version 1.02: September 13, 2020
 * * Optimization Update!
 * ** Scrolling through menus should consume less resources.
 * 
 * Version 1.01: August 30, 2020
 * * Bug Fixes!
 * ** Before, already existing Options available in the RPG Maker MZ base code
 *    such as BGM Volume, Command Remember, Always Dash, and so on, would not
 *    have their default values declared through the Options Core. The Options
 *    Core now changes this functionality and gives priority to the Plugin
 *    Parameter settings declared by the game dev. Fix made by Yanfly.
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param OptionsCore
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param OptionsSettings:struct
 * @text Options Settings
 * @type struct<OptionsSettings>
 * @desc General settings pertaining to options found here.
 * @default {"Categories":"","CategoryStyle:str":"auto","CategoryTextAlign:str":"center","Sound":"","SFXCursorList:arraystr":"[\"Default\",\"Book2\",\"Coin\",\"Cursor1\",\"Cursor2\",\"Hammer\",\"Key\",\"Knock\",\"Open1\",\"Open2\",\"Open3\",\"Paralyze1\"]","SFXOKList:arraystr":"[\"Default\",\"Bell3\",\"Computer\",\"Decision2\",\"Flash1\",\"Bell3\",\"Cat\",\"Item1\",\"Item2\",\"Item3\",\"Ice4\",\"Decision1\"]","SFXCancelList:arraystr":"[\"Default\",\"Absorb1\",\"Book1\",\"Cancel1\",\"Cancel2\",\"Raise2\",\"Skill1\",\"Dog\",\"Shot2\",\"Ice3\",\"Magic1\",\"Magic2\"]","SFXBuzzerList:arraystr":"[\"Default\",\"Buzzer2\",\"Fall\",\"Skill2\",\"Shot3\",\"Bell1\",\"Crow\",\"Horn\",\"Ice2\",\"Magic3\",\"Open4\",\"Buzzer1\"]","Text":"","FontFaces:arraystr":"[\"Default\",\"Arial\",\"Candara\",\"Calibri\",\"Garamond\",\"Georgia\",\"Gill Sans MT\",\"Helvetica\",\"Impact\",\"Lato\",\"Rockwell\",\"Segoe UI\",\"Tahoma\",\"Times\",\"Trebuchet MS\",\"Verdana\"]","ButtonAssist":"","buttonAssistCategory:str":"Switch Category"}
 *
 * @param Categories:arraystruct
 * @text Options Categories
 * @type struct<Categories>[]
 * @desc Add categories and their options here.
 * @default ["{\"Name:str\":\"General\",\"Icon:num\":\"245\",\"ShowJS:func\":\"\\\"// Return Boolean\\\\nreturn true;\\\"\",\"List:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Exploration\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"alwaysDash\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"82\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.alwaysDash;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"autosave\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"225\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.autosaveOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_1_SaveCore &&\\\\\\\\\\\\\\\\n    VisuMZ.SaveCore.Settings.AutosaveOption.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"showCompass\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"222\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.showCompass;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_4_ProximityCompass &&\\\\\\\\\\\\\\\\n    VisuMZ.ProximityCompass.Settings.Options.AddShowOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"compassSize\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"222\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.compassSize;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_4_ProximityCompass &&\\\\\\\\\\\\\\\\n    VisuMZ.ProximityCompass.Settings.Options.AddSizeOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(20);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(21);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconsole.log((Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked()))\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 50;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(50, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(50, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(50, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 100;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"dateTimeHud\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"70\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.dateTimeHud;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_DateTimeSystem &&\\\\\\\\\\\\\\\\n    VisuMZ.DateTimeSystem.Settings.Options.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"questTrackerShow\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"186\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.questTrackerShow;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_QuestSystem &&\\\\\\\\\\\\\\\\n    VisuMZ.QuestSystem.Settings.Tracker.AddShowOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"questTrackerPosition\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"186\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.questTrackerPosition;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_QuestSystem &&\\\\\\\\\\\\\\\\n    VisuMZ.QuestSystem.Settings.Tracker.AddShowOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = TextManager.questTrackerPosOff;\\\\\\\\\\\\\\\\nconst on  = TextManager.questTrackerPosOn;\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"randomEncounters\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"76\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Random Encounters\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst speedText = ['None', 'Half', 'Normal'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 3; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = speedText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 2 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 2);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 2;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"showTutorials\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"189\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.tutorial.optionsCmd;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_TutorialPanelSys &&\\\\\\\\\\\\\\\\n    VisuMZ.TutorialPanelSys.Settings.Options.AddTutorialsOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Battle\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"battleAniShow\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Show Battle Animations';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_1_OptionsCore;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst showText = ['OFF', 'SOME', 'ON'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 3; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = showText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 2 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 2);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 2;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"battleAniSpeed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Battle Animation Speed\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 4;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst speedText = ['Normal', 'Fast', 'Faster', 'Fastest'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 4; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = speedText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 3 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 3);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 3);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 3);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 3);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 3);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"battleCamera\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.battleCameraOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_3_ActSeqCamera && VisuMZ.ActSeqCamera.Settings.Options.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"commandRemember\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.commandRemember;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"atbActive\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Active Battle Style\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_BattleSystemATB && BattleManager.isATB();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'Wait';\\\\\\\\\\\\\\\\nconst on  = 'Active';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = $dataSystem.battleSystem === 1;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"atbSpeed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Active Battle Speed\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_BattleSystemATB && BattleManager.isATB();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 5;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.ctGaugeColor1();\\\\\\\\\\\\\\\\nconst color2 = ColorManager.ctGaugeColor2();\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nfor (let i = 1; i <= 5; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(true);\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * (i - 1));\\\\\\\\\\\\\\\\n    this.contents.fillRect(sx, gy, segment, 12, color0);\\\\\\\\\\\\\\\\n    if (value >= i) this.contents.gradientFillRect(sx + 1, gy + 1, segment - 2, 10, color1, color2);\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    this.drawText(i, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 5 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 1;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(1, 5);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(1, 5);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(1, 5);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 3;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(1, 5);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(1, 5);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"autoBattleAtStart\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.autoBattleStart;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.AutoBattle.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"autoBattleUseSkills\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.autoBattleStyle;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.AutoBattle.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = VisuMZ.BattleCore.Settings.AutoBattle.StyleOFF;\\\\\\\\\\\\\\\\nconst on  = VisuMZ.BattleCore.Settings.AutoBattle.StyleON;\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Screen\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"displayFPS\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"245\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Display FPS\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nif (!value) {\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"block\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._showFps = true;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"none\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"block\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._showFps = true;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"none\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\\nGraphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"none\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\\nif (config[symbol]) {\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"block\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._showFps = true;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"limitFPS\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"245\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Limit FPS\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nGraphics._app.ticker.maxFPS = ConfigManager[symbol] ? 60 : 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nGraphics._app.ticker.maxFPS = ConfigManager[symbol] ? 60 : 0;\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) SoundManager.playCursor();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nGraphics._app.ticker.maxFPS = ConfigManager[symbol] ? 60 : 0;\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) SoundManager.playCursor();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\\nGraphics._app.ticker.maxFPS = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\\nGraphics._app.ticker.maxFPS = config[symbol] ? 60 : 0;\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"fullScreen\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"245\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Full Screen\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Utils.isNwjs();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'Window Mode';\\\\\\\\\\\\\\\\nconst on  = 'Full Screen';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nGraphics._switchFullScreen();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._requestFullScreen();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._cancelFullScreen();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"stretchScreen\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"245\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Stretch Screen\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = !!Graphics._stretchEnabled;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nGraphics._switchStretchMode();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._stretchEnabled;\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._stretchEnabled = true;\\\\\\\\\\\\\\\\n    Graphics._updateAllElements();\\\\\\\\\\\\\\\\n    Graphics._stretchScreenOptionsCore();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._stretchEnabled;\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._stretchEnabled = false;\\\\\\\\\\\\\\\\n    Graphics._updateAllElements();\\\\\\\\\\\\\\\\n    Graphics._stretchScreenOptionsCore();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = !!Graphics._stretchEnabled;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\\nif (ConfigManager[symbol]) {\\\\\\\\\\\\\\\\n    Graphics._stretchEnabled = true;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    Graphics._stretchEnabled = false;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nGraphics._updateAllElements();\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"specialEffects\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"87\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Special Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_BrightEffects ||\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_HorrorEffects;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"dustCloud\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"160\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.MovementEffectsOptions.DustCloud;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_MovementEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.MovementEffects.Settings.Options.AddDustCloud\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"footprints\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"141\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.MovementEffectsOptions.Footprints;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_MovementEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.MovementEffects.Settings.Options.AddFootprints\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"smoothCamera\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.MovementEffectsOptions.SmoothCamera;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_MovementEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.MovementEffects.Settings.Options.AddSmoothCamera\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"blinkingLights\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"214\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.LightingEffectsOptions.BlinkingLights;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_LightingEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.LightingEffects.Settings.Options.AddBlinkingLights\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"pulsingLights\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"214\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.LightingEffectsOptions.PulsingLights;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_LightingEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.LightingEffects.Settings.Options.AddPulsingLights\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"weatherDensity\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"65\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.weatherDensity;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_WeatherEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.WeatherEffects.Settings.Options.AddWeatherDensityOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(4);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(0);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 100;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Controls\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn this.isRebindingEnabled();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"rebindKeyboard\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"245\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Rebind Keyboard Controls\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn this.isRebindingEnabled();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\\nSceneManager.push(Scene_RebindKeyboard);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"rebindGamepad\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Rebind Gamepad Controls\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn this.isRebindingEnabled();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\\nSceneManager.push(Scene_RebindGamepad);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn this.isRebindingEnabled();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\"}","{\"Name:str\":\"Audio\",\"Icon:num\":\"80\",\"ShowJS:func\":\"\\\"// Return Boolean\\\\nreturn true;\\\"\",\"List:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Volume\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"masterVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Master Volume\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(22);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(23);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    WebAudio.setMasterVolume(value / 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    WebAudio.setMasterVolume(value / 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    WebAudio.setMasterVolume(value / 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 100;\\\\\\\\\\\\\\\\nWebAudio.setMasterVolume(100 / 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\\nWebAudio.setMasterVolume(ConfigManager[symbol] / 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"bgmVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.bgmVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconsole.log((Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked()))\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"bgsVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.bgsVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"meVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.meVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.seVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"voiceVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.voiceVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_VoiceActControl;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"voiceLocale\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.voiceLocale;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_VoiceActControl &&\\\\\\\\\\\\\\\\n    AudioManager.isVisuMzLocalizationEnabled &&\\\\\\\\\\\\\\\\n    AudioManager.isVisuMzLocalizationEnabled() &&\\\\\\\\\\\\\\\\n    VisuMZ.VoiceActControl.Settings.Localization.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = TextManager.getAudioLanguageAt(-1) || '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = TextManager.getCurrentAudioLanguage() || '-----';\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = TextManager.getAudioLanguageAt(1) || '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"this.changeVisuMzVoiceLocale(true, true);\\\\\\\\\\\\\\\\nthis.refreshWindows();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"this.changeVisuMzVoiceLocale(true);\\\\\\\\\\\\\\\\nthis.refreshWindows();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"this.changeVisuMzVoiceLocale(false);\\\\\\\\\\\\\\\\nthis.refreshWindows();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"TF_AdvSoundOptions\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Advanced Sound Options\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.TFAdvancedSoundOptions;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\\nSceneManager.push(Scene_TFAudioOptions);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nif (Imported.TFAdvancedSoundOptions) {\\\\\\\\\\\\\\\\n    config.freq1Gain = TF._audio_1Gain || 0;\\\\\\\\\\\\\\\\n    config.freq2Gain = TF._audio_2Gain || 0;\\\\\\\\\\\\\\\\n    config.freq3Gain = TF._audio_3Gain || 0;\\\\\\\\\\\\\\\\n    config.freq4Gain = TF._audio_4Gain || 0;\\\\\\\\\\\\\\\\n    config.freq5Gain = TF._audio_5Gain || 0;\\\\\\\\\\\\\\\\n    config.freq6Gain = TF._audio_6Gain || 0;\\\\\\\\\\\\\\\\n    config.freq7Gain = TF._audio_7Gain || 0;\\\\\\\\\\\\\\\\n    config.freq8Gain = TF._audio_8Gain || 0;\\\\\\\\\\\\\\\\n    config.freq9Gain = TF._audio_9Gain || 0;\\\\\\\\\\\\\\\\n    config.preset = TF._audio_preset || \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Preset\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Sound Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"battleVoices\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"4\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.battleVoices;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_3_BattleVoices &&\\\\\\\\\\\\\\\\n    VisuMZ.BattleVoices.Settings.Options.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"footsteps\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"141\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.MovementEffectsOptions.Footsteps;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_MovementEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.MovementEffects.Settings.Options.AddSmoothCamera\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"msgLetterSound\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"189\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Letter Sounds\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_3_MessageSounds\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seCursor\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Cursor SFX\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = (value - 1) >= 0 ? 'Cursor %1'.format(value) : '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = 'Cursor %1'.format(value + 1);\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = (value + 1) < SoundManager.cursorSFXs.length ? 'Cursor %1'.format(value + 2) : '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cursorSFXs.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCursor();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cursorSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCursor();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cursorSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCursor();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seOK\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Confirm SFX\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = (value - 1) >= 0 ? 'Confirm %1'.format(value) : '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = 'Confirm %1'.format(value + 1);\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = (value + 1) < SoundManager.okSFXs.length ? 'Confirm %1'.format(value + 2) : '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.okSFXs.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playOk();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.okSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playOk();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.okSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playOk();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seCancel\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Cancel SFX\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = (value - 1) >= 0 ? 'Cancel %1'.format(value) : '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = 'Cancel %1'.format(value + 1);\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = (value + 1) < SoundManager.cancelSFXs.length ? 'Cancel %1'.format(value + 2) : '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cancelSFXs.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCancel();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cancelSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCancel();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cancelSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCancel();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seBuzzer\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Buzzer SFX\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = (value - 1) >= 0 ? 'Buzzer %1'.format(value) : '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = 'Buzzer %1'.format(value + 1);\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = (value + 1) < SoundManager.buzzerSFXs.length ? 'Buzzer %1'.format(value + 2) : '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.buzzerSFXs.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playBuzzer();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.buzzerSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playBuzzer();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.buzzerSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playBuzzer();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\"}","{\"Name:str\":\"UI\",\"Icon:num\":\"79\",\"ShowJS:func\":\"\\\"// Return Boolean\\\\nreturn true;\\\"\",\"List:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Windows\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"windowToneRed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"162\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Window Tone: Red\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = $gameSystem.windowTone()[0];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = ((value + 255) / (255 * 2)).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(10);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(2);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = value;\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[0];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 255 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = -255;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\n    value = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[0] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[0];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[0] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[0];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[0] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"windowToneGreen\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"164\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Window Tone: Green\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = $gameSystem.windowTone()[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = ((value + 255) / (255 * 2)).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(11);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(3);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = value;\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[1];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 255 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = -255;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\n    value = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[1] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[1];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[1] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[1];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[1] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"windowToneBlue\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"165\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Window Tone: Blue\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = $gameSystem.windowTone()[2];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = ((value + 255) / (255 * 2)).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(12);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(4);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = value;\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[2];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 255 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = -255;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\n    value = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[2] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[2];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[2] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[2];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[2] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Text\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"textLocale\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"189\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.messageCoreLocalization;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_1_MessageCore &&\\\\\\\\\\\\\\\\n    TextManager.isVisuMzLocalizationEnabled &&\\\\\\\\\\\\\\\\n    TextManager.isVisuMzLocalizationEnabled() &&\\\\\\\\\\\\\\\\n    VisuMZ.MessageCore.Settings.Localization.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = TextManager.getLanguageAt(-1) || '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = TextManager.getCurrentLanguage() || '-----';\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = TextManager.getLanguageAt(1) || '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"this.changeVisuMzTextLocale(true, true);\\\\\\\\\\\\\\\\nthis.refreshWindows();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"this.changeVisuMzTextLocale(true);\\\\\\\\\\\\\\\\nthis.refreshWindows();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"this.changeVisuMzTextLocale(false);\\\\\\\\\\\\\\\\nthis.refreshWindows();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"textFont\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"225\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Text Font\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = TextManager.optionsCoreFonts[value - 1] || '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = TextManager.optionsCoreFonts[value] || '-----';\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = TextManager.optionsCoreFonts[value + 1] || '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = TextManager.optionsCoreFonts.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refreshWindows();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = TextManager.optionsCoreFonts.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refreshWindows();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = TextManager.optionsCoreFonts.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refreshWindows();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"textSpeed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"225\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.messageCoreTextSpeed;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_1_MessageCore &&\\\\\\\\\\\\\\\\n    VisuMZ.MessageCore.Settings.TextSpeed.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 10).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(value > 10 ? 20 : 28);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(value > 10 ? 21 : 29);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = this.textSpeedStatusText();\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 11 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 1;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(1, 11);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(1, 11);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(1, 11);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = VisuMZ.MessageCore ? VisuMZ.MessageCore.Settings.TextSpeed.Default : 10;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(1, 11);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(1, 11);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"textEffects\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"79\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.textEffects;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_AniMsgTextEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.AniMsgTextEffects.Settings.Options.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Touch Input\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"touchUI\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"77\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.touchUI;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nif (Imported.VisuMZ_0_CoreEngine) {\\\\\\\\\\\\\\\\n    return !SceneManager.areButtonsHidden();\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    return true;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.updateButtonVisibility();\\\\\\\\\\\\\\\\nthis.updateWindowPositions();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.updateButtonVisibility();\\\\\\\\\\\\\\\\n    this.updateWindowPositions();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.updateButtonVisibility();\\\\\\\\\\\\\\\\n    this.updateWindowPositions();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiButtonPosition\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"77\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Button Position\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nif (Imported.VisuMZ_0_CoreEngine) {\\\\\\\\\\\\\\\\n    return !SceneManager.areButtonsHidden();\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    return true;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = '↑';\\\\\\\\\\\\\\\\nconst on  = '↓';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.updateButtonPositions();\\\\\\\\\\\\\\\\nthis.updateWindowPositions();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.updateButtonPositions();\\\\\\\\\\\\\\\\n    this.updateWindowPositions();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.updateButtonPositions();\\\\\\\\\\\\\\\\n    this.updateWindowPositions();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = uiDefault.ButtonPosition.call(this);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiHoverSelect\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"77\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Hover Select\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = uiDefault.hoverEnabled.call(this);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Menu Arrangement\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiMenuStyle\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Menu Style\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'Recommended';\\\\\\\\\\\\\\\\nconst on  = 'Custom';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiHelpPosition\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Help Window Position\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.uiMenuStyle;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = '↑';\\\\\\\\\\\\\\\\nconst on  = '↓';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle && !value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle && value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = uiDefault.HelpPosition.call(this);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiInputPosition\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Input Window Position\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.uiMenuStyle;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = '←';\\\\\\\\\\\\\\\\nconst on  = '→';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle && !value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle && value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = uiDefault.InputPosition.call(this);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Battle UI\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Provoke.AddOption) ||\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Aggro.AddOption) ||\\\\\\\\\\\\\\\\n    (BattleManager.isTpb() && Imported.VisuMZ_3_VisualAtbGauge && VisuMZ.VisualAtbGauge.Settings.Options.AddOption) ||\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.HpGauge.AddHpGaugeOption) ||\\\\\\\\\\\\\\\\n  false);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"provokeOrigin\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.provokeOrigin;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Provoke.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"aggroGauge\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.aggroGauge;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Aggro.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"visualHpGauge\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"84\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.visualHpGauge;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.HpGauge.AddHpGaugeOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"visualAtbGauge\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.visualAtbGauge;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn BattleManager.isTpb() && Imported.VisuMZ_2_BattleSystemATB && VisuMZ.BattleSystemATB.Settings.Options.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Provoke.AddOption) ||\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Aggro.AddOption) ||\\\\\\\\\\\\\\\\n    (BattleManager.isTpb() && Imported.VisuMZ_3_VisualAtbGauge && VisuMZ.VisualAtbGauge.Settings.Options.AddOption) ||\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.HpGauge.AddHpGaugeOption) ||\\\\\\\\\\\\\\\\n  false);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\"}","{\"Name:str\":\"Playtest\",\"Icon:num\":\"84\",\"ShowJS:func\":\"\\\"// Return Boolean\\\\nreturn $gameTemp.isPlaytest();\\\"\",\"List:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistMode\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"87\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Playtest Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Exploration\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistMapSpeed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"82\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Map Update Speed\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 4;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst speedText = ['Normal', 'Fast', 'Faster', 'Fastest'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 4; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = speedText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 3 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 3);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 3);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 3);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 3);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 3);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistRandomEncounters\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"76\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Random Encounters\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst speedText = ['None', 'Half', 'Normal'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 3; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = speedText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 2 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 2);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 2;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Battle\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistGodmode\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"God Mode\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistResistNegatives\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Resist Negative Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode && Imported.VisuMZ_1_SkillsStatesCore;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistInstantKO\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Instant K.O.\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistSkillCosts\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Skill Costs\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistConsumeItems\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Consume Items\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Rewards\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistExpMultiplier\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"88\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"EXP Multiplier\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 10).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(30);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(31);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = 'x%1'.format(2 ** value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 10 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 10);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistGoldMultiplier\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"314\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Gold Multiplier\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 10).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(14);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(6);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = 'x%1'.format(2 ** value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 10 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 10);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistDropMultiplier\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"176\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Drop Multiplier\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 10).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(11);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(3);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = 'x%1'.format(2 ** value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 10 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 10);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Spawners\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistSpawnItems\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"176\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Spawn Items\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Spawn Items\\\\\\\\\\\\\\\\nconst goods = [];\\\\\\\\\\\\\\\\nfor (const item of $dataItems) {\\\\\\\\\\\\\\\\n    if (item && item.name.trim() !== '') {\\\\\\\\\\\\\\\\n        goods.push([0, item.id, 1, 0]);\\\\\\\\\\\\\\\\n    }\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nSceneManager.push(Scene_Shop);\\\\\\\\\\\\\\\\nSceneManager.prepareNextScene(goods, true);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistSpawnWeapons\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Spawn Weapons\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Spawn Items\\\\\\\\\\\\\\\\nconst goods = [];\\\\\\\\\\\\\\\\nfor (const item of $dataWeapons) {\\\\\\\\\\\\\\\\n    if (item && item.name.trim() !== '') {\\\\\\\\\\\\\\\\n        goods.push([1, item.id, 1, 0]);\\\\\\\\\\\\\\\\n    }\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nSceneManager.push(Scene_Shop);\\\\\\\\\\\\\\\\nSceneManager.prepareNextScene(goods, true);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistSpawnArmors\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"137\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Spawn Armors\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Spawn Items\\\\\\\\\\\\\\\\nconst goods = [];\\\\\\\\\\\\\\\\nfor (const item of $dataArmors) {\\\\\\\\\\\\\\\\n    if (item && item.name.trim() !== '') {\\\\\\\\\\\\\\\\n        goods.push([2, item.id, 1, 0]);\\\\\\\\\\\\\\\\n    }\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nSceneManager.push(Scene_Shop);\\\\\\\\\\\\\\\\nSceneManager.prepareNextScene(goods, true);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Debug\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistCallDebug\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"89\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Debug Menu\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Call Debug Menu\\\\\\\\\\\\\\\\nSceneManager.push(Scene_Debug);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\"}"]
 *
 * @param Rebind:struct
 * @text Keyboard/Controller Rebind
 * @type struct<Rebind>
 * @desc Settings that allow the player to rebind their keyboard
 * and controller inputs. Requires VisuMZ_0_CoreEngine!
 * @default {"General":"","EnableRebind:eval":"true","keyOrder:arraystr":"[\"up\",\"left\",\"down\",\"right\",\"ok\",\"escape\",\"shift\",\"tab\",\"pageup\",\"pagedown\"]","gamepadOrder:arraystr":"[\"up\",\"left\",\"down\",\"right\",\"ok\",\"cancel\",\"menu\",\"shift\",\"pageup\",\"pagedown\"]","gamepadReset:func":"\"Input.gamepadMapper = {\\n    0: \\\"ok\\\", // A\\n    1: \\\"cancel\\\", // B\\n    2: \\\"shift\\\", // X\\n    3: \\\"menu\\\", // Y\\n    4: \\\"pageup\\\", // LB\\n    5: \\\"pagedown\\\", // RB\\n    12: \\\"up\\\", // D-pad up\\n    13: \\\"down\\\", // D-pad down\\n    14: \\\"left\\\", // D-pad left\\n    15: \\\"right\\\" // D-pad right\\n};\"","Vocab":"","ButtonVocab":"","up:str":"Up","left:str":"Left","down:str":"Down","right:str":"Right","ok:str":"Confirm","escape:str":"Cancel & Menu","cancel:str":"Cancel","menu:str":"Menu","pageup:str":"Switch Left","pagedown:str":"Switch Right","shift:str":"Dash","tab:str":"Tab","buttonFmt:str":"\\}Button\\{ %1","dpadFmt:str":"\\}D-Pad\\{ %1","ButtonAssistVocab":"","removeAssist:str":"Remove","resetAssist:str":"Reset","confirmAssist:str":"Rebind","cancelAssist:str":"Exit","HelpVocab":"","selectKeyboard:json":"\"Select a key to rebind/change.\"","pressKeyboard:json":"\"Press a keyboard button to assign this control.\"","pressForbidden:json":"\"That key cannot be bound to a control.\"","selectGamepad:json":"\"Select a button to rebind/change.\"","pressGamepad:json":"\"Press a gamepad button to assign this control.\"","buttonForbidden:json":"\"This button cannot be reassigned.\"","noGamepadFound:json":"\"No gamepad is detected!\"","Windows":"","HelpWindow":"","HelpWindow_BgType:num":"0","RebindWindow":"","RebindWindow_BgType:num":"0","keyNameAlign:str":"center","rebindAlign:str":"center","RebindWindow_RectJS:func":"\"const buffer = 48;\\nconst ww = Math.ceil((Graphics.boxWidth - (buffer * 2)) * (this.isForGamepad() ? 2/3 : 1));\\nconst wh = this.mainAreaHeight() - (buffer * 2);\\nconst wx = Math.floor((Graphics.boxWidth - ww) / 2);\\nconst wy = this.mainAreaTop() + Math.floor((this.mainAreaHeight() - wh) / 2);\\nreturn new Rectangle(wx, wy, ww, wh);\"","HelpRebindWindow":"","HelpRebindWindow_BgType:num":"0","HelpRebindWindow_RectJS:func":"\"const ww = Math.ceil(Graphics.boxWidth * 2/3);\\nconst wh = this.calcWindowHeight(2, false);\\nconst wx = Math.floor((Graphics.boxWidth - ww) / 2);\\nconst wy = Math.floor((Graphics.boxHeight - wh) / 2);\\nreturn new Rectangle(wx, wy, ww, wh);\""}
 *
 * @param ControllerButtons:arraystruct
 * @text Controller Buttons
 * @parent Rebind:struct
 * @type struct<ControllerButtons>[]
 * @desc Make different icons appear for different controllers.
 * Requires VisuMZ_0_CoreEngine!
 * @default []
 *
 * @param MasterVolShortcut:struct
 * @text Master Volume Shortcut
 * @type struct<MasterVolShortcut>
 * @desc Settings regarding the Master Volume Shortcut keys.
 * Shortcut: Ctrl + PageUp / Ctrl + PageDn
 * @default {"Shortcut":"","Enable:eval":"true","change:num":"10","Sfx":"","VolUpSfx":"","upName:str":"Up1","upVolume:num":"90","upPitch:num":"100","upPan:num":"0","VolDnSfx":"","downName:str":"Down1","downVolume:num":"90","downPitch:num":"100","downPan:num":"0"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Categories List
 * ----------------------------------------------------------------------------
 */
/*~struct~Categories:
 *
 * @param Name:str
 * @text Name
 * @desc The name of this category as seen in the Category Window.
 * Text codes are supported.
 * @default Untitled
 *
 * @param Icon:num
 * @text Icon
 * @parent Name:str
 * @desc Icon used for this category.
 * Use 0 for no icon.
 * @default 0
 *
 * @param ShowJS:func
 * @text JS: Show/Hide
 * @parent Name:str
 * @type note
 * @desc Code used to determine if this category is visible.
 * @default "// Return Boolean\nreturn true;"
 *
 * @param List:arraystruct
 * @text Options List
 * @type struct<Options>[]
 * @desc Add options to this category here.
 * @default []
 *
 */
/* ----------------------------------------------------------------------------
 * Options List
 * ----------------------------------------------------------------------------
 */
/*~struct~Options:
 *
 * @param Symbol:str
 * @text Symbol
 * @desc Symbol used for this option when selected.
 * Make sure this is unique from other symbols.
 * @default Symbol
 *
 * @param Icon:num
 * @text Icon
 * @parent Symbol:str
 * @desc Icon used for this option.
 * Use 0 for no icon.
 * @default 0
 *
 * @param TextStr:str
 * @text STR: Text
 * @parent Symbol:str
 * @desc Displayed text used for this option.
 * If this has a value, ignore the JS: Text version.
 * @default Untitled
 *
 * @param TextJS:func
 * @text JS: Text
 * @parent Symbol:str
 * @type note
 * @desc JavaScript code used to determine string used for the displayed name.
 * @default "return 'Text';"
 *
 * @param Accessibility
 *
 * @param ShowJS:func
 * @text JS: Show/Hide
 * @parent Accessibility
 * @type note
 * @desc Code used to determine if this option is visible.
 * @default "// Return Boolean\nreturn true;"
 *
 * @param EnableJS:func
 * @text JS: Enable
 * @parent Accessibility
 * @type note
 * @desc Code used to determine if this option is enabled.
 * @default "// Return Boolean\nreturn true;"
 *
 * @param ExtJS:func
 * @text JS: Ext
 * @parent Accessibility
 * @type note
 * @desc Code used to determine if this option's ext value.
 * @default "// Return Value\nreturn 0;"
 *
 * @param Functions
 *
 * @param DrawJS:func
 * @text JS: Draw Option
 * @parent Functions
 * @type note
 * @desc Code used to draw this item into the List Window.
 * @default "// Declare Constants\nconst symbol = arguments[0];\nconst index = arguments[1];\nconst title = this.commandName(index);\nconst rect = this.itemLineRect(index);\nconst quarterWidth = rect.width / 4;\nconst halfWidth = rect.width / 2;\nconst value = this.getConfigValue(symbol);\n\n// Draw Command Name\nthis.resetFontSettings();\nthis.changePaintOpacity(true);\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \"left\");\n\n// Draw Status Text\nconst off = 'OFF';\nconst on  = 'ON';\nthis.changePaintOpacity(!value);\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \"center\");\nthis.changePaintOpacity(value);\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \"center\");"
 *
 * @param ProcessOkJS:func
 * @text JS: Process OK
 * @parent Functions
 * @type note
 * @desc Code used when OK button is pressed while selected.
 * @default "// Declare Constants\nconst symbol = arguments[0];\nconst value = this.getConfigValue(symbol);\n\n// Perform Actions\nthis.setConfigValue(symbol, !value);\nthis.redrawItem(this.findSymbol(symbol));\nthis.playCursorSound();"
 *
 * @param CursorRightJS:func
 * @text JS: Cursor Right
 * @parent Functions
 * @type note
 * @desc Code used when Right button is pressed while selected.
 * @default "// Declare Constants\nconst symbol = arguments[0];\nconst value = this.getConfigValue(symbol);\nconst lastValue = value;\n\n// Perform Actions\nthis.setConfigValue(symbol, true);\nthis.redrawItem(this.findSymbol(symbol));\nif (this.getConfigValue(symbol) !== lastValue) {\n    this.playCursorSound();\n}"
 *
 * @param CursorLeftJS:func
 * @text JS: Cursor Left
 * @parent Functions
 * @type note
 * @desc Code used when Left button is pressed while selected.
 * @default "// Declare Constants\nconst symbol = arguments[0];\nconst value = this.getConfigValue(symbol);\nconst lastValue = value;\n\n// Perform Actions\nthis.setConfigValue(symbol, false);\nthis.redrawItem(this.findSymbol(symbol));\nif (this.getConfigValue(symbol) !== lastValue) {\n    this.playCursorSound();\n}"
 *
 * @param Data
 *
 * @param DefaultJS:func
 * @text JS: Default Value
 * @parent Data
 * @type note
 * @desc Code used to determine the default value of this option.
 * @default "// Declare Constants\nconst config = arguments[0];\nconst symbol = arguments[1];\n\n// Perform Actions\nConfigManager[symbol] = false;"
 *
 * @param SaveJS:func
 * @text JS: Save Option
 * @parent Data
 * @type note
 * @desc Code used when saving this options setting.
 * @default "// Declare Constants\nconst config = arguments[0];\nconst symbol = arguments[1];\n\n// Return Value\nconfig[symbol] = ConfigManager[symbol];"
 *
 * @param LoadJS:func
 * @text JS: Load Option
 * @parent Data
 * @type note
 * @desc Code used when loading this options setting.
 * @default "// Declare Constants\nconst config = arguments[0];\nconst symbol = arguments[1];\n\n// Return Value\nConfigManager[symbol] = config[symbol];"
 *
 */
/* ----------------------------------------------------------------------------
 * Options Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~OptionsSettings:
 *
 * @param Categories
 *
 * @param CategoryStyle:str
 * @text Category Window Style
 * @parent Categories
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Category Window?
 * @default auto
 *
 * @param CategoryTextAlign:str
 * @text Category Text Align
 * @parent Categories
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Command Window.
 * @default center
 *
 * @param categoryWindowBgType:num
 * @text Background Type
 * @parent Categories
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param OptionsWindow
 * @text Options Window
 *
 * @param optionsWindowBgType:num
 * @text Background Type
 * @parent OptionsWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ButtonAssist
 * @text Button Assist Window
 *
 * @param buttonAssistCategory:str
 * @text Switch Category
 * @parent ButtonAssist
 * @desc Button assist text used for switching categories.
 * For VisuStella MZ's Core Engine's Button Assist Window.
 * @default Switch Category
 *
 * @param buttonAssistBgType:num
 * @text Background Type
 * @parent ButtonAssist
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * Requires VisuMZ_0_CoreEngine!
 * @default 0
 *
 * @param Sound
 *
 * @param SFXCursorList:arraystr
 * @text Cursor Sounds
 * @parent Sound
 * @type file[]
 * @dir audio/se/
 * @desc SE files player can select from for cursor SE.
 * The first in the list will always be the default SE.
 * @default ["Default"]
 *
 * @param SFXOKList:arraystr
 * @text OK Sounds
 * @parent Sound
 * @type file[]
 * @dir audio/se/
 * @desc SE files player can select from for OK SE.
 * The first in the list will always be the default SE.
 * @default ["Default"]
 *
 * @param SFXCancelList:arraystr
 * @text Cancel Sounds
 * @parent Sound
 * @type file[]
 * @dir audio/se/
 * @desc SE files player can select from for cancel SE.
 * The first in the list will always be the default SE.
 * @default ["Default"]
 *
 * @param SFXBuzzerList:arraystr
 * @text Buzzer Sounds
 * @parent Sound
 * @type file[]
 * @dir audio/se/
 * @desc SE files player can select from for buzzer SE.
 * The first in the list will always be the default SE.
 * @default ["Default"]
 *
 * @param Text
 *
 * @param FontFaces:arraystr
 * @text Font Options
 * @parent Text
 * @type string[]
 * @desc Available fonts for the player to select from.
 * The first font in the list is always be the default font.
 * @default ["Default","Arial","Verdana","Times New Roman"]
 *
 */
/* ----------------------------------------------------------------------------
 * Rebind Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Rebind:
 *
 * @param General
 * @text General Settings
 *
 * @param EnableRebind:eval
 * @text Enable Rebinding?
 * @parent General
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable keyboard and controller rebinding?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 *
 * @param keyOrder:arraystr
 * @text Keyboard Bindings
 * @parent General
 * @type select[]
 * @option up
 * @option left
 * @option down
 * @option right
 * @option ok
 * @option escape
 * @option cancel
 * @option menu
 * @option shift
 * @option tab
 * @option pageup
 * @option pagedown
 * @desc Select the keys that can be rebound and the order they appear for keyboard.
 * @default ["up","left","down","right","ok","escape","shift","tab","pageup","pagedown"]
 *
 * @param gamepadOrder:arraystr
 * @text Gamepad Bindings
 * @parent General
 * @type select[]
 * @option up
 * @option left
 * @option down
 * @option right
 * @option ok
 * @option escape
 * @option cancel
 * @option menu
 * @option shift
 * @option tab
 * @option pageup
 * @option pagedown
 * @desc Select the keys that can be rebound and the order they appear for gamepad.
 * @default ["up","left","down","right","ok","cancel","menu","shift","pageup","pagedown"]
 *
 * @param gamepadReset:func
 * @text JS: Reset Gamepad
 * @parent gamepadOrder:arraystr
 * @type note
 * @desc Determine how the gamepad map should be when reset.
 * @default "Input.gamepadMapper = {\n    0: \"ok\", // A\n    1: \"cancel\", // B\n    2: \"shift\", // X\n    3: \"menu\", // Y\n    4: \"pageup\", // LB\n    5: \"pagedown\", // RB\n    12: \"up\", // D-pad up\n    13: \"down\", // D-pad down\n    14: \"left\", // D-pad left\n    15: \"right\" // D-pad right\n};"
 *
 * @param Vocab
 * @text Vocabulary
 *
 * @param ButtonVocab
 * @text Button Vocab
 * @parent Vocab
 *
 * @param up:str
 * @text Up
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Up
 *
 * @param left:str
 * @text Left
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Left
 *
 * @param down:str
 * @text Down
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Down
 *
 * @param right:str
 * @text Right
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Right
 *
 * @param ok:str
 * @text OK
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Confirm
 *
 * @param escape:str
 * @text Escape
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Cancel & Menu
 *
 * @param cancel:str
 * @text Cancel
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Cancel
 *
 * @param menu:str
 * @text Menu
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Menu
 *
 * @param pageup:str
 * @text Page Up
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Switch Left
 *
 * @param pagedown:str
 * @text Page Down
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Switch Right
 *
 * @param shift:str
 * @text Shift
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Dash
 *
 * @param tab:str
 * @text Tab
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Tab
 *
 * @param buttonFmt:str
 * @text Button Format
 * @parent ButtonVocab
 * @desc Text format for unassigned gamepad buttons.
 * Text codes allowed. %1 - Button ID.
 * @default \}Button\{ %1
 *
 * @param dpadFmt:str
 * @text D-Pad Format
 * @parent ButtonVocab
 * @desc Text format for directional pad buttons.
 * Text codes allowed. %1 - Direction.
 * @default \}D-Pad\{ %1
 *
 * @param ButtonAssistVocab
 * @text Button Assist
 * @parent Vocab
 *
 * @param removeAssist:str
 * @text Shift: Remove
 * @parent ButtonAssistVocab
 * @desc Text used to represent this button assist.
 * @default Remove
 *
 * @param resetAssist:str
 * @text Shift: Reset
 * @parent ButtonAssistVocab
 * @desc Text used to represent this button assist.
 * @default Reset
 *
 * @param confirmAssist:str
 * @text OK: Select
 * @parent ButtonAssistVocab
 * @desc Text used to represent this button assist.
 * @default Rebind
 *
 * @param cancelAssist:str
 * @text Cancel: Exit
 * @parent ButtonAssistVocab
 * @desc Text used to represent this button assist.
 * @default Exit
 *
 * @param HelpVocab
 * @text Help Descriptions
 * @parent Vocab
 *
 * @param selectKeyboard:json
 * @text Select for Keyboard
 * @parent HelpVocab
 * @type note
 * @desc Help description used for selecting a keyboard button.
 * Text codes allowed.
 * @default "Select a key to rebind/change."
 *
 * @param pressKeyboard:json
 * @text Keyboard Instruct
 * @parent HelpVocab
 * @type note
 * @desc Help description used to ask for a key to press.
 * Text codes allowed.
 * @default "Press a keyboard button to assign this control."
 *
 * @param pressForbidden:json
 * @text Forbidden Key
 * @parent HelpVocab
 * @type note
 * @desc Help description used when a keyboard key cannot be used.
 * Text codes allowed.
 * @default "That key cannot be bound to a control."
 *
 * @param selectGamepad:json
 * @text Select for Gamepad
 * @parent HelpVocab
 * @type note
 * @desc Help description used for selecting a gamepad button.
 * Text codes allowed.
 * @default "Select a button to rebind/change."
 *
 * @param pressGamepad:json
 * @text Gamepad Instructions
 * @parent HelpVocab
 * @type note
 * @desc Help description used to ask for a gamepad button to press.
 * Text codes allowed.
 * @default "Press a gamepad button to assign this control."
 *
 * @param buttonForbidden:json
 * @text Forbidden Button
 * @parent HelpVocab
 * @type note
 * @desc Help description used when a gamepad button cannot be reassigned.
 * Text codes allowed.
 * @default "This button cannot be reassigned."
 *
 * @param noGamepadFound:json
 * @text No Gamepad Detected
 * @parent HelpVocab
 * @type note
 * @desc Help description used when no gamepad is detected.
 * Text codes allowed.
 * @default "No gamepad is detected!"
 *
 * @param Windows
 * @text Window Settings
 *
 * @param HelpWindow
 * @text Window_Help
 * @parent Windows
 *
 * @param HelpWindow_BgType:num
 * @text Background Type
 * @parent HelpWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param RebindWindow
 * @text Window_KeyRebinds
 * @parent Windows
 *
 * @param RebindWindow_BgType:num
 * @text Background Type
 * @parent RebindWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param keyNameAlign:str
 * @text Key Type Align
 * @parent RebindWindow
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the key types?
 * @default center
 *
 * @param rebindAlign:str
 * @text Rebind Key Align
 * @parent RebindWindow
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the rebind key?
 * @default center
 *
 * @param RebindWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent RebindWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const buffer = 48;\nconst ww = Math.ceil((Graphics.boxWidth - (buffer * 2)) * (this.isForGamepad() ? 2/3 : 1));\nconst wh = this.mainAreaHeight() - (buffer * 2);\nconst wx = Math.floor((Graphics.boxWidth - ww) / 2);\nconst wy = this.mainAreaTop() + Math.floor((this.mainAreaHeight() - wh) / 2);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param HelpRebindWindow
 * @text Window_RebindHelp
 * @parent Windows
 *
 * @param HelpRebindWindow_BgType:num
 * @text Background Type
 * @parent HelpRebindWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param HelpRebindWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent HelpRebindWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.ceil(Graphics.boxWidth * 2/3);\nconst wh = this.calcWindowHeight(2, false);\nconst wx = Math.floor((Graphics.boxWidth - ww) / 2);\nconst wy = Math.floor((Graphics.boxHeight - wh) / 2);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 */
/* ----------------------------------------------------------------------------
 * Controller Buttons Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ControllerButtons:
 *
 * @param ID
 * @text ID Information
 *
 * @param Name:str
 * @text Controller ID Name
 * @parent ID
 * @desc Exact string used for this controller ID.
 * User VisuMZ_0_CoreEngine plugin commands for help.
 * @default Untitled
 *
 * @param Match:str
 * @text Similarity Match
 * @parent ID
 * @desc Similar text used for this controller ID.
 * User VisuMZ_0_CoreEngine plugin commands for help.
 * @default Untitled
 * 
 * @param Buttons
 * @text Button Text
 *
 * @param button0:str
 * @text Button 0
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 0
 *
 * @param button1:str
 * @text Button 1
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 1
 *
 * @param button2:str
 * @text Button 2
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 2
 *
 * @param button3:str
 * @text Button 3
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 3
 *
 * @param button4:str
 * @text Button 4
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 4
 *
 * @param button5:str
 * @text Button 5
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 5
 *
 * @param button6:str
 * @text Button 6
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 6
 *
 * @param button7:str
 * @text Button 7
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 7
 *
 * @param button8:str
 * @text Button 8
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 8
 *
 * @param button9:str
 * @text Button 9
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 9
 *
 * @param button10:str
 * @text Button 10
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 10
 *
 * @param button11:str
 * @text Button 11
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 11
 *
 * @param button12:str
 * @text Button 12
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}D-Pad\{ Up
 *
 * @param button13:str
 * @text Button 13
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}D-Pad\{ Down
 *
 * @param button14:str
 * @text Button 14
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}D-Pad\{ Left
 *
 * @param button15:str
 * @text Button 15
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}D-Pad\{ Right
 *
 * @param button16:str
 * @text Button 16
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 16
 *
 * @param button17:str
 * @text Button 17
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 17
 *
 * @param button18:str
 * @text Button 18
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 18
 *
 * @param button19:str
 * @text Button 19
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 19
 *
 * @param button20:str
 * @text Button 20
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 20
 * 
*/
/* ----------------------------------------------------------------------------
 * Master Volume Shortcut Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MasterVolShortcut:
 * 
 * @param Shortcut
 *
 * @param Enable:eval
 * @text Enabled?
 * @parent Shortcut
 * @type boolean
 * @on Enable Shortcut
 * @off Disable Shortcut
 * @desc Enable the shortcut?
 * Shortcut: Ctrl + PageUp / Ctrl + PageDn
 * @default true
 *
 * @param change:num
 * @text Shortcut Change Value
 * @parent Shortcut
 * @type number
 * @min 1
 * @max 100
 * @desc What is the change amount for the shortcut key?
 * Master volume caps at 0 and 100.
 * @default 10
 * 
 * @param Sfx
 * @text Sound Effects
 * 
 * @param VolUpSfx
 * @text Volume Up
 * @parent Sfx
 *
 * @param upName:str
 * @text Filename
 * @parent VolUpSfx
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Up1
 *
 * @param upVolume:num
 * @text Volume
 * @parent VolUpSfx
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param upPitch:num
 * @text Pitch
 * @parent VolUpSfx
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param upPan:num
 * @text Pan
 * @parent VolUpSfx
 * @desc Pan of the sound effect played.
 * @default 0
 * 
 * @param VolDnSfx
 * @text Volume Down
 * @parent Sfx
 *
 * @param downName:str
 * @text Filename
 * @parent VolDnSfx
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Down1
 *
 * @param downVolume:num
 * @text Volume
 * @parent VolDnSfx
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param downPitch:num
 * @text Pitch
 * @parent VolDnSfx
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param downPan:num
 * @text Pan
 * @parent VolDnSfx
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
//=============================================================================

const _0x16899c=_0x3be1;(function(_0x443f9b,_0xabeba7){const _0x1bbe0b=_0x3be1,_0x13c223=_0x443f9b();while(!![]){try{const _0x4b81f2=parseInt(_0x1bbe0b(0x354))/0x1*(-parseInt(_0x1bbe0b(0x263))/0x2)+-parseInt(_0x1bbe0b(0x1ef))/0x3*(parseInt(_0x1bbe0b(0x3c2))/0x4)+-parseInt(_0x1bbe0b(0x34d))/0x5+-parseInt(_0x1bbe0b(0x2a7))/0x6*(parseInt(_0x1bbe0b(0x1f1))/0x7)+-parseInt(_0x1bbe0b(0x332))/0x8+parseInt(_0x1bbe0b(0x272))/0x9+parseInt(_0x1bbe0b(0x391))/0xa;if(_0x4b81f2===_0xabeba7)break;else _0x13c223['push'](_0x13c223['shift']());}catch(_0x549e29){_0x13c223['push'](_0x13c223['shift']());}}}(_0x525f,0xbafa9));function _0x3be1(_0x501054,_0x460e92){const _0x525fe8=_0x525f();return _0x3be1=function(_0x3be1eb,_0x558e2c){_0x3be1eb=_0x3be1eb-0x1e9;let _0x2429ad=_0x525fe8[_0x3be1eb];return _0x2429ad;},_0x3be1(_0x501054,_0x460e92);}var label=_0x16899c(0x3c1),tier=tier||0x0,dependencies=[],pluginData=$plugins['filter'](function(_0x55a590){const _0x4379fa=_0x16899c;return _0x55a590[_0x4379fa(0x218)]&&_0x55a590[_0x4379fa(0x3b6)]['includes']('['+label+']');})[0x0];VisuMZ[label]['Settings']=VisuMZ[label][_0x16899c(0x277)]||{},VisuMZ['ConvertParams']=function(_0x1d71c5,_0x4e1620){const _0x13ab3a=_0x16899c;for(const _0xcad3f2 in _0x4e1620){if(_0xcad3f2[_0x13ab3a(0x30f)](/(.*):(.*)/i)){const _0x22a5fb=String(RegExp['$1']),_0x448962=String(RegExp['$2'])[_0x13ab3a(0x3d2)]()['trim']();let _0x7bc8a0,_0x18473e,_0x1f3014;switch(_0x448962){case _0x13ab3a(0x254):_0x7bc8a0=_0x4e1620[_0xcad3f2]!==''?Number(_0x4e1620[_0xcad3f2]):0x0;break;case _0x13ab3a(0x20f):_0x18473e=_0x4e1620[_0xcad3f2]!==''?JSON['parse'](_0x4e1620[_0xcad3f2]):[],_0x7bc8a0=_0x18473e[_0x13ab3a(0x311)](_0x193a63=>Number(_0x193a63));break;case'EVAL':_0x7bc8a0=_0x4e1620[_0xcad3f2]!==''?eval(_0x4e1620[_0xcad3f2]):null;break;case _0x13ab3a(0x2b1):_0x18473e=_0x4e1620[_0xcad3f2]!==''?JSON['parse'](_0x4e1620[_0xcad3f2]):[],_0x7bc8a0=_0x18473e['map'](_0x29501a=>eval(_0x29501a));break;case _0x13ab3a(0x3ec):_0x7bc8a0=_0x4e1620[_0xcad3f2]!==''?JSON[_0x13ab3a(0x2d2)](_0x4e1620[_0xcad3f2]):'';break;case _0x13ab3a(0x242):_0x18473e=_0x4e1620[_0xcad3f2]!==''?JSON[_0x13ab3a(0x2d2)](_0x4e1620[_0xcad3f2]):[],_0x7bc8a0=_0x18473e[_0x13ab3a(0x311)](_0x112b5a=>JSON[_0x13ab3a(0x2d2)](_0x112b5a));break;case _0x13ab3a(0x38f):_0x7bc8a0=_0x4e1620[_0xcad3f2]!==''?new Function(JSON[_0x13ab3a(0x2d2)](_0x4e1620[_0xcad3f2])):new Function(_0x13ab3a(0x372));break;case _0x13ab3a(0x409):_0x18473e=_0x4e1620[_0xcad3f2]!==''?JSON[_0x13ab3a(0x2d2)](_0x4e1620[_0xcad3f2]):[],_0x7bc8a0=_0x18473e[_0x13ab3a(0x311)](_0x53ca4a=>new Function(JSON[_0x13ab3a(0x2d2)](_0x53ca4a)));break;case _0x13ab3a(0x329):_0x7bc8a0=_0x4e1620[_0xcad3f2]!==''?String(_0x4e1620[_0xcad3f2]):'';break;case _0x13ab3a(0x2df):_0x18473e=_0x4e1620[_0xcad3f2]!==''?JSON['parse'](_0x4e1620[_0xcad3f2]):[],_0x7bc8a0=_0x18473e[_0x13ab3a(0x311)](_0x7b3a5b=>String(_0x7b3a5b));break;case _0x13ab3a(0x1ec):_0x1f3014=_0x4e1620[_0xcad3f2]!==''?JSON['parse'](_0x4e1620[_0xcad3f2]):{},_0x1d71c5[_0x22a5fb]={},VisuMZ[_0x13ab3a(0x2f7)](_0x1d71c5[_0x22a5fb],_0x1f3014);continue;case _0x13ab3a(0x2f2):_0x18473e=_0x4e1620[_0xcad3f2]!==''?JSON[_0x13ab3a(0x2d2)](_0x4e1620[_0xcad3f2]):[],_0x7bc8a0=_0x18473e['map'](_0x5baf46=>VisuMZ[_0x13ab3a(0x2f7)]({},JSON['parse'](_0x5baf46)));break;default:continue;}_0x1d71c5[_0x22a5fb]=_0x7bc8a0;}}return _0x1d71c5;},(_0x333b47=>{const _0x558622=_0x16899c,_0x2f4d60=_0x333b47[_0x558622(0x3d4)];for(const _0x22ee37 of dependencies){if(!Imported[_0x22ee37]){alert('%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.'[_0x558622(0x3f5)](_0x2f4d60,_0x22ee37)),SceneManager[_0x558622(0x406)]();break;}}const _0x2dc079=_0x333b47['description'];if(_0x2dc079[_0x558622(0x30f)](/\[Version[ ](.*?)\]/i)){const _0x498fe6=Number(RegExp['$1']);_0x498fe6!==VisuMZ[label][_0x558622(0x371)]&&(alert(_0x558622(0x327)[_0x558622(0x3f5)](_0x2f4d60,_0x498fe6)),SceneManager['exit']());}if(_0x2dc079[_0x558622(0x30f)](/\[Tier[ ](\d+)\]/i)){const _0x2b541f=Number(RegExp['$1']);_0x2b541f<tier?(alert('%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.'['format'](_0x2f4d60,_0x2b541f,tier)),SceneManager[_0x558622(0x406)]()):tier=Math['max'](_0x2b541f,tier);}VisuMZ[_0x558622(0x2f7)](VisuMZ[label][_0x558622(0x277)],_0x333b47[_0x558622(0x362)]);})(pluginData),VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x289)]=Scene_Boot[_0x16899c(0x2dd)][_0x16899c(0x3c6)],Scene_Boot[_0x16899c(0x2dd)][_0x16899c(0x3c6)]=function(){const _0x379663=_0x16899c;this[_0x379663(0x3e0)](),VisuMZ[_0x379663(0x3c1)][_0x379663(0x289)]['call'](this),VisuMZ['OptionsCore']['CheckCompatibility'](),SoundManager[_0x379663(0x34a)](),this[_0x379663(0x295)](),this[_0x379663(0x25b)](),!Utils[_0x379663(0x20d)]('test')&&(ConfigManager[_0x379663(0x40f)]=![]);},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x249)]=function(){const _0x151d44=_0x16899c;if(Imported[_0x151d44(0x377)]&&VisuMZ[_0x151d44(0x3aa)]['version']<1.64){let _0x10033c='';_0x10033c+='VisuMZ_0_CoreEngine\x20needs\x20to\x20be\x20updated\x20',_0x10033c+=_0x151d44(0x25d),alert(_0x10033c),SceneManager[_0x151d44(0x406)]();}if(Imported['VisuMZ_3_ButtonTriggerEvts']&&VisuMZ[_0x151d44(0x32c)][_0x151d44(0x371)]<1.05){let _0x2633d2='';_0x2633d2+=_0x151d44(0x2e4),_0x2633d2+=_0x151d44(0x25d),alert(_0x2633d2),SceneManager[_0x151d44(0x406)]();}if(Imported[_0x151d44(0x221)]&&VisuMZ[_0x151d44(0x2d7)]['version']<1.09){let _0x54e964='';_0x54e964+=_0x151d44(0x2fa),_0x54e964+='in\x20order\x20for\x20VisuMZ_1_OptionsCore\x20to\x20work.',alert(_0x54e964),SceneManager['exit']();}},Scene_Boot['prototype'][_0x16899c(0x3e0)]=function(){const _0x227141=_0x16899c,_0x2ca8f2=[_0x227141(0x398),_0x227141(0x212),_0x227141(0x2ca),_0x227141(0x2ce),_0x227141(0x238),'meVolume','seVolume'];for(const _0x1b0968 of VisuMZ['OptionsCore'][_0x227141(0x277)][_0x227141(0x223)]){for(const _0x35b25e of _0x1b0968[_0x227141(0x27f)]){if(!_0x35b25e)continue;const _0xb710a8=_0x35b25e['Symbol'];if(!_0xb710a8)continue;if(_0x2ca8f2['includes'](_0xb710a8))ConfigManager[_0xb710a8]=undefined;_0x35b25e[_0x227141(0x20a)][_0x227141(0x3d3)](this,ConfigManager,_0xb710a8);}}},Scene_Boot['prototype'][_0x16899c(0x295)]=function(){const _0x4d58be=_0x16899c;if(VisuMZ[_0x4d58be(0x3c1)][_0x4d58be(0x21f)]())return;const _0x2d3161=_0x4d58be(0x353),_0xefab36=[0x3,0x8,0x5,0x1,0x14,0x13],_0x141860=_0xefab36['reduce']((_0x290234,_0x19e1a6)=>_0x290234+_0x2d3161[_0x19e1a6],''),_0x4299c2={'Name:str':_0x141860,'Icon:num':'7','ShowJS:func':_0x4d58be(0x1e9),'List:arraystruct':_0x4d58be(0x226)};Window_OptionsCategory[_0x4d58be(0x3c0)]['push'](VisuMZ['ConvertParams'](_0x4299c2,_0x4299c2));},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x21f)]=function(){const _0x301bba=_0x16899c,_0x1e6d06=_0x301bba(0x353),_0x3a6b7e=[0x1,0x13,0x13,0x9,0x13,0x14,0xd,0xf,0x4,0x5],_0x236aea=_0x3a6b7e['reduce']((_0x1ee485,_0x1b3d56)=>_0x1ee485+_0x1e6d06[_0x1b3d56],'');for(const _0x439399 of Window_OptionsCategory['categoryList']){if(!_0x439399)continue;for(const _0x442a99 of _0x439399[_0x301bba(0x27f)]){if(!_0x442a99)continue;if(_0x442a99[_0x301bba(0x31c)]['toLowerCase']()['trim']()===_0x236aea)return!![];}}return![];},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x2c8)]={},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x3c3)]={},Scene_Boot[_0x16899c(0x2dd)]['process_VisuMZ_OptionsCore_ControllerButtons']=function(){const _0x24cdb5=_0x16899c,_0x533918=VisuMZ[_0x24cdb5(0x3c1)][_0x24cdb5(0x277)][_0x24cdb5(0x2c8)];for(const _0x114e6f of _0x533918){const _0x56be99=(_0x114e6f[_0x24cdb5(0x410)]||'')[_0x24cdb5(0x256)]()[_0x24cdb5(0x27b)](),_0x4f6902=(_0x114e6f[_0x24cdb5(0x37f)]||'')[_0x24cdb5(0x256)]()[_0x24cdb5(0x27b)]();VisuMZ[_0x24cdb5(0x3c1)][_0x24cdb5(0x2c8)][_0x56be99]=_0x114e6f,VisuMZ[_0x24cdb5(0x3c1)]['ControllerMatches'][_0x4f6902]=_0x56be99;}},VisuMZ['OptionsCore'][_0x16899c(0x22a)]=ConfigManager[_0x16899c(0x341)],ConfigManager[_0x16899c(0x341)]=function(){const _0x103bb4=_0x16899c;if(this['_saving']||this[_0x103bb4(0x33d)])return;VisuMZ['OptionsCore'][_0x103bb4(0x22a)][_0x103bb4(0x3d3)](this);},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x206)]=ConfigManager[_0x16899c(0x3ee)],ConfigManager[_0x16899c(0x3ee)]=function(){const _0x1664d8=_0x16899c;let _0x4afdc6=VisuMZ[_0x1664d8(0x3c1)][_0x1664d8(0x206)][_0x1664d8(0x3d3)](this);;return _0x4afdc6=this[_0x1664d8(0x20c)](_0x4afdc6),_0x4afdc6=this[_0x1664d8(0x2f9)](_0x4afdc6),!Utils[_0x1664d8(0x20d)](_0x1664d8(0x214))&&(_0x4afdc6[_0x1664d8(0x40f)]=![]),_0x4afdc6;},ConfigManager['makeDataOptionsCore']=function(_0x35e1ea){const _0x55bdf7=_0x16899c;this['_saving']=!![];for(const _0x340fc8 of Window_OptionsCategory[_0x55bdf7(0x3c0)]){for(const _0x54deea of _0x340fc8['List']){if(!_0x54deea)continue;const _0x6b79ce=_0x54deea[_0x55bdf7(0x31c)];if(!_0x6b79ce)continue;ConfigManager[_0x6b79ce]===undefined&&_0x54deea[_0x55bdf7(0x20a)][_0x55bdf7(0x3d3)](this,_0x35e1ea,_0x6b79ce),_0x54deea['SaveJS']['call'](this,_0x35e1ea,_0x6b79ce);}}return this[_0x55bdf7(0x23b)]=![],_0x35e1ea;},ConfigManager[_0x16899c(0x2f9)]=function(_0x17202a){const _0x59fa83=_0x16899c;if(!Scene_Options['ADD_REBIND_OPTIONS'])return _0x17202a;return _0x17202a[_0x59fa83(0x37b)]=Input[_0x59fa83(0x37b)],_0x17202a[_0x59fa83(0x2d3)]=Input['gamepadMapper'],_0x17202a;},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x1fa)]=ConfigManager[_0x16899c(0x404)],ConfigManager[_0x16899c(0x404)]=function(_0x29ed09){const _0xb630d0=_0x16899c;VisuMZ[_0xb630d0(0x3c1)]['ConfigManager_applyData'][_0xb630d0(0x3d3)](this,_0x29ed09),this['applyDataOptionsCore'](_0x29ed09),this[_0xb630d0(0x366)](_0x29ed09);},ConfigManager['applyDataOptionsCore']=function(_0xf9af24){const _0x443e7c=_0x16899c;this[_0x443e7c(0x33d)]=!![];for(const _0x191594 of Window_OptionsCategory[_0x443e7c(0x3c0)]){for(const _0x55a50e of _0x191594[_0x443e7c(0x27f)]){if(!_0x55a50e)continue;const _0x549b75=_0x55a50e[_0x443e7c(0x31c)];if(!_0x549b75)continue;_0xf9af24[_0x549b75]===undefined?_0x55a50e[_0x443e7c(0x20a)]['call'](this,_0xf9af24,_0x549b75):_0x55a50e[_0x443e7c(0x3b0)][_0x443e7c(0x3d3)](this,_0xf9af24,_0x549b75);}}this[_0x443e7c(0x33d)]=![];},ConfigManager[_0x16899c(0x366)]=function(_0x518666){const _0x48d4c4=_0x16899c;_0x518666[_0x48d4c4(0x37b)]&&(Input[_0x48d4c4(0x37b)]=_0x518666[_0x48d4c4(0x37b)]),_0x518666[_0x48d4c4(0x2d3)]&&(Input[_0x48d4c4(0x2d3)]=_0x518666[_0x48d4c4(0x2d3)]);},Graphics[_0x16899c(0x247)]=function(){const _0x54f0fd=_0x16899c;return this[_0x54f0fd(0x24f)]&&this[_0x54f0fd(0x24f)]['_boxDiv'][_0x54f0fd(0x2f5)][_0x54f0fd(0x208)]!==_0x54f0fd(0x36a);},VisuMZ['OptionsCore']['Graphics_FPSCounter_switchMode']=Graphics[_0x16899c(0x211)][_0x16899c(0x2dd)]['switchMode'],Graphics[_0x16899c(0x211)][_0x16899c(0x2dd)][_0x16899c(0x3db)]=function(){const _0x14f48b=_0x16899c;VisuMZ[_0x14f48b(0x3c1)][_0x14f48b(0x2de)][_0x14f48b(0x3d3)](this),this[_0x14f48b(0x38c)]();},Graphics['FPSCounter']['prototype'][_0x16899c(0x38c)]=function(){const _0x586bcb=_0x16899c;ConfigManager&&ConfigManager[_0x586bcb(0x32b)]!==undefined&&(ConfigManager[_0x586bcb(0x32b)]=Graphics[_0x586bcb(0x247)](),ConfigManager['save']());if(SceneManager&&SceneManager['_scene']){const _0x23ce40=SceneManager[_0x586bcb(0x365)];_0x23ce40[_0x586bcb(0x339)](),_0x23ce40[_0x586bcb(0x2e1)]===Scene_Options&&_0x23ce40[_0x586bcb(0x301)]();}},VisuMZ[_0x16899c(0x3c1)]['Scene_Boot_start']=Scene_Boot['prototype'][_0x16899c(0x403)],Scene_Boot[_0x16899c(0x2dd)][_0x16899c(0x403)]=function(){const _0x23595c=_0x16899c;VisuMZ['OptionsCore'][_0x23595c(0x286)][_0x23595c(0x3d3)](this),ConfigManager&&ConfigManager[_0x23595c(0x3f9)]&&Graphics[_0x23595c(0x2e2)]();},VisuMZ['OptionsCore'][_0x16899c(0x37a)]=Graphics[_0x16899c(0x21d)],Graphics['_switchFullScreen']=function(){const _0xa8c56b=_0x16899c;this['_isFullScreen']()?ConfigManager[_0xa8c56b(0x3f9)]=![]:ConfigManager[_0xa8c56b(0x3f9)]=!![],ConfigManager[_0xa8c56b(0x341)](),VisuMZ['OptionsCore']['Graphics_switchFullScreen'][_0xa8c56b(0x3d3)](this),Graphics[_0xa8c56b(0x305)]();},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x3a4)]=Graphics[_0x16899c(0x2e2)],Graphics[_0x16899c(0x2e2)]=function(){const _0x54a0b2=_0x16899c;VisuMZ[_0x54a0b2(0x3c1)][_0x54a0b2(0x3a4)]['call'](this),this[_0x54a0b2(0x305)]();},VisuMZ['OptionsCore'][_0x16899c(0x2ba)]=Graphics[_0x16899c(0x3ad)],Graphics['_cancelFullScreen']=function(){const _0x39e1ca=_0x16899c;VisuMZ[_0x39e1ca(0x3c1)][_0x39e1ca(0x2ba)]['call'](this),this[_0x39e1ca(0x305)]();},Graphics[_0x16899c(0x305)]=function(){const _0x41207f=_0x16899c;if(SceneManager&&SceneManager['_scene']){const _0x1c9192=SceneManager[_0x41207f(0x365)];_0x1c9192[_0x41207f(0x2e1)]===Scene_Options&&setTimeout(_0x1c9192[_0x41207f(0x301)][_0x41207f(0x1f6)](_0x1c9192),0x64);}},VisuMZ['OptionsCore'][_0x16899c(0x2b8)]=Graphics['_switchStretchMode'],Graphics[_0x16899c(0x2c6)]=function(){const _0x57f27d=_0x16899c;VisuMZ[_0x57f27d(0x3c1)]['Graphics_switchStretchMode'][_0x57f27d(0x3d3)](this),this[_0x57f27d(0x3bb)]();},Graphics[_0x16899c(0x3bb)]=function(){const _0xeb15f5=_0x16899c;ConfigManager&&ConfigManager[_0xeb15f5(0x28d)]!==undefined&&(ConfigManager[_0xeb15f5(0x28d)]=!!this[_0xeb15f5(0x213)],setTimeout(ConfigManager[_0xeb15f5(0x341)]['bind'](ConfigManager),0x64));if(SceneManager&&SceneManager[_0xeb15f5(0x365)]){const _0x421613=SceneManager[_0xeb15f5(0x365)];_0x421613['constructor']===Scene_Options&&setTimeout(_0x421613[_0xeb15f5(0x301)]['bind'](_0x421613),0x64);}},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x3f8)]={'enabled':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)][_0x16899c(0x30d)]['Enable']??!![],'change':VisuMZ['OptionsCore'][_0x16899c(0x277)][_0x16899c(0x30d)]['change']??!![]},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x3a9)]=Input[_0x16899c(0x294)],Input[_0x16899c(0x294)]=function(_0x78fe78){const _0x5a0e95=_0x16899c;if(VisuMZ[_0x5a0e95(0x3c1)]['meetVolumeShortcutConditions'](_0x78fe78,![]))return VisuMZ['OptionsCore'][_0x5a0e95(0x2fd)](_0x78fe78),![];return VisuMZ[_0x5a0e95(0x3c1)][_0x5a0e95(0x3a9)]['call'](this,_0x78fe78);},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x3f3)]=Input[_0x16899c(0x2ae)],Input[_0x16899c(0x2ae)]=function(_0xb8c0ab){const _0x550833=_0x16899c;if(VisuMZ['OptionsCore'][_0x550833(0x2ad)](_0xb8c0ab,!![]))return VisuMZ[_0x550833(0x3c1)][_0x550833(0x2fd)](_0xb8c0ab),![];return VisuMZ[_0x550833(0x3c1)][_0x550833(0x3f3)][_0x550833(0x3d3)](this,_0xb8c0ab);},VisuMZ['OptionsCore'][_0x16899c(0x2ad)]=function(_0x89c2,_0x2dc370){const _0x3c2993=_0x16899c;if(!VisuMZ['OptionsCore'][_0x3c2993(0x3f8)][_0x3c2993(0x30c)])return![];if(ConfigManager[_0x3c2993(0x40c)]===undefined)return![];if(!Input[_0x3c2993(0x2a8)]('control'))return![];if(_0x89c2!==_0x3c2993(0x2ed)&&_0x89c2!==_0x3c2993(0x2a4))return![];return _0x2dc370?VisuMZ[_0x3c2993(0x3c1)][_0x3c2993(0x3f3)][_0x3c2993(0x3d3)](Input,_0x89c2):VisuMZ[_0x3c2993(0x3c1)][_0x3c2993(0x3a9)][_0x3c2993(0x3d3)](Input,_0x89c2);},VisuMZ['OptionsCore']['processVolumeShortcut']=function(_0x43ff88){const _0x45b7b3=_0x16899c,_0x52e510=this[_0x45b7b3(0x30b)](_0x43ff88);this['updateOptionsCoreScene'](_0x52e510);},VisuMZ[_0x16899c(0x3c1)]['changeMasterVolumeViaShortcut']=function(_0x41a43c){const _0x21f5a6=_0x16899c,_0xf6ea7d=VisuMZ['OptionsCore'][_0x21f5a6(0x3f8)][_0x21f5a6(0x35d)];let _0x47cf88=Math[_0x21f5a6(0x297)](WebAudio[_0x21f5a6(0x23e)]*0x64);const _0x49393a=ConfigManager[_0x21f5a6(0x40c)];if(_0x41a43c===_0x21f5a6(0x2ed))_0x47cf88+=_0xf6ea7d;else _0x41a43c===_0x21f5a6(0x2a4)&&(_0x47cf88-=_0xf6ea7d);_0x47cf88=_0x47cf88[_0x21f5a6(0x3cb)](0x0,0x64),ConfigManager[_0x21f5a6(0x40c)]=_0x47cf88,ConfigManager[_0x21f5a6(0x341)](),_0x47cf88/=0x64,WebAudio[_0x21f5a6(0x3cd)](_0x47cf88);if(_0x49393a!==ConfigManager[_0x21f5a6(0x40c)]){if(_0x41a43c===_0x21f5a6(0x2ed))SoundManager[_0x21f5a6(0x323)]();else _0x41a43c===_0x21f5a6(0x2a4)&&SoundManager[_0x21f5a6(0x3af)]();}return ConfigManager[_0x21f5a6(0x40c)]!==_0x49393a;},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x31d)]=function(_0x483f4c){const _0x49d6b8=_0x16899c;if(!_0x483f4c)return;const _0x5a6b2a=SceneManager[_0x49d6b8(0x365)];if(_0x5a6b2a[_0x49d6b8(0x2e1)]!==Scene_Options)return;_0x5a6b2a[_0x49d6b8(0x380)]['refresh']();},Input[_0x16899c(0x20e)]=function(_0x138ec4){const _0x44cbde=_0x16899c,_0x4788c7=[];for(const _0x3f0d89 in Input['keyMapper']){const _0x57d62c=Number(_0x3f0d89);if([0x60,0x62,0x64,0x66,0x68,0x20,0x2d][_0x44cbde(0x291)](_0x57d62c))continue;Input[_0x44cbde(0x37b)][_0x57d62c]===_0x138ec4&&_0x4788c7['push'](_0x57d62c);}return _0x4788c7;},Input[_0x16899c(0x2c7)]=function(_0x3f92cf){const _0x3101b1=_0x16899c,_0x1527e6=[];for(const _0x1e6ca0 in Input[_0x3101b1(0x2d3)]){const _0x563455=Number(_0x1e6ca0);Input['gamepadMapper'][_0x563455]===_0x3f92cf&&_0x1527e6[_0x3101b1(0x2be)](_0x563455);}return _0x1527e6;},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x35e)]=Input[_0x16899c(0x230)],Input[_0x16899c(0x230)]=function(_0x2a338a){const _0x5437c9=_0x16899c;VisuMZ[_0x5437c9(0x3c1)]['Input_updateGamepadState'][_0x5437c9(0x3d3)](this,_0x2a338a),this[_0x5437c9(0x24b)]&&(this[_0x5437c9(0x39f)]=this[_0x5437c9(0x3b7)][_0x2a338a[_0x5437c9(0x3d6)]]['indexOf'](!![]));},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x40b)]=DataManager[_0x16899c(0x227)],DataManager['setupNewGame']=function(){const _0xc4214d=_0x16899c,_0x2f769a=($gameSystem?$gameSystem[_0xc4214d(0x376)]():$dataSystem[_0xc4214d(0x376)])['slice'](0x0);VisuMZ['OptionsCore']['DataManager_setupNewGame'][_0xc4214d(0x3d3)](this),$gameSystem[_0xc4214d(0x360)](_0x2f769a);},SoundManager[_0x16899c(0x3a6)]=JsonEx['makeDeepCopy'](VisuMZ[_0x16899c(0x3c1)]['Settings']['OptionsSettings']['SFXCursorList']),SoundManager[_0x16899c(0x290)]=JsonEx[_0x16899c(0x3f7)](VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)][_0x16899c(0x33b)]['SFXOKList']),SoundManager[_0x16899c(0x337)]=JsonEx[_0x16899c(0x3f7)](VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)]['OptionsSettings'][_0x16899c(0x228)]),SoundManager['buzzerSFXs']=JsonEx['makeDeepCopy'](VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)][_0x16899c(0x33b)][_0x16899c(0x225)]),SoundManager[_0x16899c(0x34a)]=function(){const _0x2485e4=_0x16899c,_0x4f6f04=[];_0x4f6f04[_0x2485e4(0x2be)](SoundManager['cursorSFXs']),_0x4f6f04[_0x2485e4(0x2be)](SoundManager[_0x2485e4(0x290)]),_0x4f6f04[_0x2485e4(0x2be)](SoundManager[_0x2485e4(0x337)]),_0x4f6f04[_0x2485e4(0x2be)](SoundManager[_0x2485e4(0x333)]);let _0x473790=0x0;for(const _0x22a3cf of _0x4f6f04){for(let _0x40e3ba=0x1;_0x40e3ba<_0x22a3cf[_0x2485e4(0x2ff)];_0x40e3ba++){const _0x14751a=_0x22a3cf[_0x40e3ba],_0xd8ed75=JsonEx['makeDeepCopy']($dataSystem['sounds'][_0x473790]);_0xd8ed75[_0x2485e4(0x3d4)]=_0x14751a,_0x22a3cf[_0x40e3ba]=_0xd8ed75;}_0x473790++;}},VisuMZ['OptionsCore'][_0x16899c(0x222)]=SoundManager[_0x16899c(0x1f9)],SoundManager[_0x16899c(0x1f9)]=function(){const _0x290d5c=_0x16899c;if(ConfigManager&&ConfigManager['seCursor']!==undefined){if(ConfigManager[_0x290d5c(0x1fd)]>0x0){const _0x3c149e=SoundManager['cursorSFXs'][ConfigManager[_0x290d5c(0x1fd)]];if(_0x3c149e)return AudioManager[_0x290d5c(0x24d)](_0x3c149e);}}VisuMZ['OptionsCore']['SoundManager_playCursor'][_0x290d5c(0x3d3)](this);},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x3d9)]=SoundManager[_0x16899c(0x338)],SoundManager[_0x16899c(0x338)]=function(){const _0x5800eb=_0x16899c;if(ConfigManager&&ConfigManager[_0x5800eb(0x32e)]!==undefined){if(ConfigManager[_0x5800eb(0x32e)]>0x0){const _0x2b41d7=SoundManager[_0x5800eb(0x290)][ConfigManager[_0x5800eb(0x32e)]];if(_0x2b41d7)return AudioManager[_0x5800eb(0x24d)](_0x2b41d7);}}VisuMZ['OptionsCore'][_0x5800eb(0x3d9)][_0x5800eb(0x3d3)](this);},VisuMZ['OptionsCore'][_0x16899c(0x388)]=SoundManager['playCancel'],SoundManager[_0x16899c(0x33f)]=function(){const _0x26051d=_0x16899c;if(ConfigManager&&ConfigManager[_0x26051d(0x390)]!==undefined){if(ConfigManager[_0x26051d(0x390)]>0x0){const _0x26e363=SoundManager[_0x26051d(0x337)][ConfigManager['seCancel']];if(_0x26e363)return AudioManager['playStaticSe'](_0x26e363);}}VisuMZ[_0x26051d(0x3c1)][_0x26051d(0x388)][_0x26051d(0x3d3)](this);},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x3ce)]=SoundManager[_0x16899c(0x3b9)],SoundManager[_0x16899c(0x3b9)]=function(){const _0x23966a=_0x16899c;if(ConfigManager&&ConfigManager[_0x23966a(0x39b)]!==undefined){if(ConfigManager[_0x23966a(0x39b)]>0x0){const _0x5afa7f=SoundManager[_0x23966a(0x333)][ConfigManager[_0x23966a(0x39b)]];if(_0x5afa7f)return AudioManager[_0x23966a(0x24d)](_0x5afa7f);}}VisuMZ[_0x23966a(0x3c1)][_0x23966a(0x3ce)][_0x23966a(0x3d3)](this);},SoundManager[_0x16899c(0x323)]=function(){const _0x279ccc=_0x16899c,_0x28781e=VisuMZ[_0x279ccc(0x3c1)]['Settings'][_0x279ccc(0x30d)],_0x38666b={'name':_0x28781e[_0x279ccc(0x203)],'volume':_0x28781e['upVolume'],'pitch':_0x28781e[_0x279ccc(0x2a2)],'pan':_0x28781e[_0x279ccc(0x2d8)]};AudioManager[_0x279ccc(0x400)](_0x38666b);},SoundManager[_0x16899c(0x3af)]=function(){const _0x345bda=_0x16899c,_0x3573f3=VisuMZ[_0x345bda(0x3c1)][_0x345bda(0x277)][_0x345bda(0x30d)],_0x33f227={'name':_0x3573f3[_0x345bda(0x39d)],'volume':_0x3573f3[_0x345bda(0x202)],'pitch':_0x3573f3[_0x345bda(0x35a)],'pan':_0x3573f3['downPan']};AudioManager[_0x345bda(0x400)](_0x33f227);},TextManager[_0x16899c(0x298)]=VisuMZ[_0x16899c(0x3c1)]['Settings'][_0x16899c(0x33b)]['FontFaces'],TextManager[_0x16899c(0x383)]={'up':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)][_0x16899c(0x2e9)]['up']??'Up','left':VisuMZ['OptionsCore'][_0x16899c(0x277)][_0x16899c(0x2e9)][_0x16899c(0x2fb)]??'Left','down':VisuMZ[_0x16899c(0x3c1)]['Settings'][_0x16899c(0x2e9)][_0x16899c(0x241)]??_0x16899c(0x1fc),'right':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)][_0x16899c(0x2e9)][_0x16899c(0x351)]??_0x16899c(0x246),'ok':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)]['Rebind']['ok']??_0x16899c(0x31a),'escape':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)]['Rebind'][_0x16899c(0x33e)]??'Cancel\x20&\x20Menu','cancel':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)][_0x16899c(0x2e9)][_0x16899c(0x284)]??_0x16899c(0x271),'menu':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)][_0x16899c(0x2e9)]['menu']??'Menu','pageup':VisuMZ['OptionsCore'][_0x16899c(0x277)][_0x16899c(0x2e9)][_0x16899c(0x2ed)]??_0x16899c(0x2eb),'pagedown':VisuMZ['OptionsCore'][_0x16899c(0x277)]['Rebind']['pagedown']??_0x16899c(0x40d),'shift':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)][_0x16899c(0x2e9)][_0x16899c(0x21e)]??_0x16899c(0x244),'tab':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)][_0x16899c(0x2e9)][_0x16899c(0x385)]??_0x16899c(0x2ac),'buttonFmt':VisuMZ[_0x16899c(0x3c1)]['Settings'][_0x16899c(0x2e9)][_0x16899c(0x359)]??_0x16899c(0x3c5),'dpadFmt':VisuMZ['OptionsCore']['Settings'][_0x16899c(0x2e9)][_0x16899c(0x36d)]??'\x5c}D-Pad\x5c{\x20%1'},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x3b5)]=TextManager[_0x16899c(0x28b)],TextManager['getControllerInputButtonString']=function(_0x5d36cd,_0x1668d4){const _0x263e4a=_0x16899c;if(Scene_Options[_0x263e4a(0x349)])return this['rebindControllerInputButtonString'](_0x5d36cd,_0x1668d4);return VisuMZ[_0x263e4a(0x3c1)]['TextManager_getControllerInputButtonString'][_0x263e4a(0x3d3)](this,_0x5d36cd,_0x1668d4);},TextManager[_0x16899c(0x325)]=function(_0x19186a,_0x4aad8e){const _0x490ce4=_0x16899c,_0x3d7853=_0x19186a[_0x490ce4(0x256)]()[_0x490ce4(0x27b)](),_0xca636f=Input[_0x490ce4(0x2c7)](_0x4aad8e)[0x0],_0x42a439=VisuMZ[_0x490ce4(0x3c1)][_0x490ce4(0x3b5)];if(VisuMZ[_0x490ce4(0x3c1)][_0x490ce4(0x2c8)][_0x3d7853]){const _0x4e716b=VisuMZ[_0x490ce4(0x3c1)][_0x490ce4(0x2c8)][_0x3d7853];return _0x4e716b[_0x490ce4(0x3ff)[_0x490ce4(0x3f5)](_0xca636f)]||_0x42a439[_0x490ce4(0x3d3)](this,_0x19186a,_0x4aad8e);}else{if(!!TextManager[_0x490ce4(0x318)](_0x3d7853)){const _0xd30850=TextManager[_0x490ce4(0x318)](_0x3d7853);return _0xd30850['button%1'['format'](_0xca636f)]||_0x42a439[_0x490ce4(0x3d3)](this,_0x19186a,_0x4aad8e);}else{if(!$gameTemp[_0x490ce4(0x32f)]){if(_0xca636f===0x0)return _0x42a439[_0x490ce4(0x3d3)](this,_0x19186a,'ok');if(_0xca636f===0x1)return _0x42a439['call'](this,_0x19186a,_0x490ce4(0x284));if(_0xca636f===0x2)return _0x42a439[_0x490ce4(0x3d3)](this,_0x19186a,'shift');if(_0xca636f===0x3)return _0x42a439[_0x490ce4(0x3d3)](this,_0x19186a,_0x490ce4(0x232));if(_0xca636f===0x4)return _0x42a439['call'](this,_0x19186a,'pageup');if(_0xca636f===0x5)return _0x42a439[_0x490ce4(0x3d3)](this,_0x19186a,_0x490ce4(0x2a4));if(_0xca636f===0xc)return _0x42a439[_0x490ce4(0x3d3)](this,_0x19186a,'up');if(_0xca636f===0xd)return _0x42a439[_0x490ce4(0x3d3)](this,_0x19186a,_0x490ce4(0x241));if(_0xca636f===0xe)return _0x42a439[_0x490ce4(0x3d3)](this,_0x19186a,_0x490ce4(0x2fb));if(_0xca636f===0xf)return _0x42a439[_0x490ce4(0x3d3)](this,_0x19186a,_0x490ce4(0x351));}if([0xc,0xd,0xe,0xf][_0x490ce4(0x291)](_0xca636f)){const _0x126e08=TextManager[_0x490ce4(0x383)][_0x490ce4(0x36d)];return _0x126e08[_0x490ce4(0x3f5)](TextManager['REBIND'][_0x4aad8e]);}else{const _0x4c4914=TextManager[_0x490ce4(0x383)][_0x490ce4(0x359)];return _0x4c4914[_0x490ce4(0x3f5)](_0xca636f);}}}return _0x42a439[_0x490ce4(0x3d3)](this,_0x19186a,_0x4aad8e);},TextManager[_0x16899c(0x318)]=function(_0xf22b59){const _0x402216=_0x16899c;for(const _0x1cf4ed in VisuMZ[_0x402216(0x3c1)][_0x402216(0x3c3)]){if(_0xf22b59[_0x402216(0x291)](_0x1cf4ed)){const _0xcd8bff=VisuMZ[_0x402216(0x3c1)]['ControllerMatches'][_0x1cf4ed];return VisuMZ['OptionsCore'][_0x402216(0x2c8)][_0xcd8bff];}}return null;};if(Imported[_0x16899c(0x377)]){VisuMZ[_0x16899c(0x3c1)]['Game_Temp_requestAnimation']=Game_Temp['prototype']['requestAnimation'],Game_Temp[_0x16899c(0x2dd)][_0x16899c(0x408)]=function(_0x414655,_0x29f91a,_0x39cb88){const _0x3a8a4d=_0x16899c;if(!this[_0x3a8a4d(0x3ed)]())return;VisuMZ[_0x3a8a4d(0x3c1)]['Game_Temp_requestAnimation'][_0x3a8a4d(0x3d3)](this,_0x414655,_0x29f91a,_0x39cb88);},Game_Temp[_0x16899c(0x2dd)][_0x16899c(0x3ed)]=function(){const _0x3370ca=_0x16899c;if($gameParty[_0x3370ca(0x2d0)]()&&ConfigManager&&ConfigManager[_0x3370ca(0x1ff)]!==undefined)return ConfigManager[_0x3370ca(0x1ff)]>=0x1;return!![];};Game_Temp[_0x16899c(0x2dd)][_0x16899c(0x326)]&&(VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x29b)]=Game_Temp['prototype'][_0x16899c(0x326)],Game_Temp['prototype'][_0x16899c(0x326)]=function(){const _0x1abefa=_0x16899c;if($gameParty[_0x1abefa(0x2d0)]()&&ConfigManager&&ConfigManager[_0x1abefa(0x1ff)]!==undefined)return ConfigManager[_0x1abefa(0x1ff)]>=0x2;return VisuMZ[_0x1abefa(0x3c1)][_0x1abefa(0x29b)][_0x1abefa(0x3d3)](this);});;};VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x204)]=Game_System[_0x16899c(0x2dd)][_0x16899c(0x3ea)],Game_System[_0x16899c(0x2dd)][_0x16899c(0x3ea)]=function(){const _0x4ad5b1=_0x16899c;VisuMZ[_0x4ad5b1(0x3c1)][_0x4ad5b1(0x204)][_0x4ad5b1(0x3d3)](this),this[_0x4ad5b1(0x3dc)]();},Game_System[_0x16899c(0x2dd)][_0x16899c(0x3dc)]=function(){const _0xb7a363=_0x16899c;this[_0xb7a363(0x384)]=JsonEx['makeDeepCopy']($dataSystem['windowTone']);},Game_System[_0x16899c(0x2dd)][_0x16899c(0x376)]=function(){const _0x4bfb30=_0x16899c;if(this[_0x4bfb30(0x384)])return this[_0x4bfb30(0x384)];return this[_0x4bfb30(0x3dc)](),this[_0x4bfb30(0x384)];},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x231)]=Game_System[_0x16899c(0x2dd)][_0x16899c(0x2f0)],Game_System['prototype'][_0x16899c(0x2f0)]=function(){const _0x48e86e=_0x16899c,_0x4c9a99=VisuMZ[_0x48e86e(0x3c1)][_0x48e86e(0x231)][_0x48e86e(0x3d3)](this);if(ConfigManager&&ConfigManager['textFont']!==undefined){if(ConfigManager['textFont']>0x0)return TextManager[_0x48e86e(0x298)][ConfigManager[_0x48e86e(0x2e5)]]||_0x4c9a99;}return _0x4c9a99;},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x3de)]=Game_Action[_0x16899c(0x2dd)]['executeHpDamage'],Game_Action['prototype'][_0x16899c(0x405)]=function(_0x17dbb1,_0x16271f){const _0x4fec09=_0x16899c;if(ConfigManager[_0x4fec09(0x40f)]){if(this[_0x4fec09(0x234)]()[_0x4fec09(0x26e)]()&&_0x17dbb1[_0x4fec09(0x24e)]()){if(ConfigManager[_0x4fec09(0x29a)])_0x16271f=Math[_0x4fec09(0x346)](_0x16271f,_0x17dbb1[_0x4fec09(0x344)]);}}VisuMZ[_0x4fec09(0x3c1)][_0x4fec09(0x3de)][_0x4fec09(0x3d3)](this,_0x17dbb1,_0x16271f);},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x34f)]=Game_BattlerBase[_0x16899c(0x2dd)][_0x16899c(0x2a6)],Game_BattlerBase[_0x16899c(0x2dd)][_0x16899c(0x2a6)]=function(_0x5bb2a8){const _0x517772=_0x16899c;if(ConfigManager['assistMode']&&this[_0x517772(0x26e)]()){if(ConfigManager[_0x517772(0x302)]&&_0x5bb2a8===this[_0x517772(0x3a1)]())return!![];if(Imported['VisuMZ_1_SkillsStatesCore']&&ConfigManager[_0x517772(0x36e)]){const _0x487e7c=$dataStates[_0x5bb2a8];if(_0x487e7c&&_0x487e7c['categories']&&_0x487e7c[_0x517772(0x34b)][_0x517772(0x291)](_0x517772(0x265)))return!![];}}return VisuMZ['OptionsCore'][_0x517772(0x34f)]['call'](this,_0x5bb2a8);},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x37c)]=Game_Battler[_0x16899c(0x2dd)][_0x16899c(0x22b)],Game_Battler[_0x16899c(0x2dd)][_0x16899c(0x22b)]=function(_0x3ad839){const _0x198216=_0x16899c;if(ConfigManager&&ConfigManager[_0x198216(0x40f)]&&this['isActor']()){if(DataManager[_0x198216(0x2d4)](_0x3ad839)&&ConfigManager[_0x198216(0x210)]===![])return;if(DataManager['isItem'](_0x3ad839)&&ConfigManager[_0x198216(0x250)]===![])return;}VisuMZ[_0x198216(0x3c1)][_0x198216(0x37c)][_0x198216(0x3d3)](this,_0x3ad839);},VisuMZ['OptionsCore'][_0x16899c(0x283)]=Game_Battler[_0x16899c(0x2dd)][_0x16899c(0x3f0)],Game_Battler[_0x16899c(0x2dd)][_0x16899c(0x3f0)]=function(_0x2d589c,_0x4a0f06){const _0x51f55f=_0x16899c;if(ConfigManager['assistMode']&&this['isActor']()){if(Imported[_0x51f55f(0x38a)]&&ConfigManager[_0x51f55f(0x36e)])return!![];}VisuMZ[_0x51f55f(0x3c1)][_0x51f55f(0x283)][_0x51f55f(0x3d3)](this,_0x2d589c,_0x4a0f06);},VisuMZ['OptionsCore'][_0x16899c(0x26a)]=Game_Enemy['prototype'][_0x16899c(0x2a1)],Game_Enemy[_0x16899c(0x2dd)][_0x16899c(0x2a1)]=function(){const _0x3664fe=_0x16899c;let _0x493bea=VisuMZ[_0x3664fe(0x3c1)]['Game_Enemy_dropItemRate'][_0x3664fe(0x3d3)](this);return ConfigManager[_0x3664fe(0x40f)]&&(_0x493bea*=0x2**(ConfigManager['assistDropMultiplier']||0x0)),_0x493bea;},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x394)]=Game_Party[_0x16899c(0x2dd)][_0x16899c(0x2e8)],Game_Party['prototype']['hasEncounterHalf']=function(){const _0x519791=_0x16899c;if(ConfigManager[_0x519791(0x40f)]&&ConfigManager[_0x519791(0x328)]===0x1)return!![];if(ConfigManager['randomEncounters']===0x1)return!![];return VisuMZ['OptionsCore'][_0x519791(0x394)][_0x519791(0x3d3)](this);},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x2d5)]=Game_Party[_0x16899c(0x2dd)]['hasEncounterNone'],Game_Party['prototype'][_0x16899c(0x40e)]=function(){const _0x1b9043=_0x16899c;if(ConfigManager['assistMode']&&ConfigManager[_0x1b9043(0x328)]===0x0)return!![];if(ConfigManager[_0x1b9043(0x2b3)]===0x0)return!![];return VisuMZ[_0x1b9043(0x3c1)][_0x1b9043(0x2d5)][_0x1b9043(0x3d3)](this);},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x30a)]=Game_Troop[_0x16899c(0x2dd)][_0x16899c(0x22e)],Game_Troop[_0x16899c(0x2dd)]['expTotal']=function(){const _0x4afca3=_0x16899c;let _0x198e97=VisuMZ['OptionsCore'][_0x4afca3(0x30a)]['call'](this);return ConfigManager['assistMode']&&(_0x198e97*=0x2**(ConfigManager[_0x4afca3(0x274)]||0x0)),_0x198e97;},VisuMZ['OptionsCore'][_0x16899c(0x2a3)]=Game_Troop[_0x16899c(0x2dd)][_0x16899c(0x368)],Game_Troop['prototype'][_0x16899c(0x368)]=function(){const _0x4dd806=_0x16899c;let _0x2ca06c=VisuMZ[_0x4dd806(0x3c1)][_0x4dd806(0x2a3)]['call'](this);return ConfigManager[_0x4dd806(0x40f)]&&(_0x2ca06c*=0x2**(ConfigManager[_0x4dd806(0x370)]||0x0)),_0x2ca06c;};var uiDefault=uiDefault||{};uiDefault['HelpPosition']=Scene_Base['prototype'][_0x16899c(0x22d)],Scene_Base[_0x16899c(0x2dd)][_0x16899c(0x22d)]=function(){const _0x9b52d2=_0x16899c;return ConfigManager[_0x9b52d2(0x3d8)]&&ConfigManager[_0x9b52d2(0x3b2)]!==undefined?ConfigManager[_0x9b52d2(0x3b2)]:uiDefault['HelpPosition']['call'](this);},uiDefault[_0x16899c(0x25f)]=Scene_Base[_0x16899c(0x2dd)][_0x16899c(0x401)],Scene_Base['prototype'][_0x16899c(0x401)]=function(){const _0x521f7c=_0x16899c;return ConfigManager[_0x521f7c(0x207)]!==undefined?ConfigManager['uiButtonPosition']:uiDefault['ButtonPosition'][_0x521f7c(0x3d3)](this);},uiDefault[_0x16899c(0x392)]=Scene_Base[_0x16899c(0x2dd)]['isRightInputMode'],Scene_Base[_0x16899c(0x2dd)][_0x16899c(0x2b5)]=function(){const _0xea938=_0x16899c;return ConfigManager['uiMenuStyle']&&ConfigManager[_0xea938(0x240)]!==undefined?ConfigManager[_0xea938(0x240)]:uiDefault['InputPosition'][_0xea938(0x3d3)](this);},Scene_Base[_0x16899c(0x2dd)]['updateButtonVisibility']=function(){const _0xea72b5=_0x16899c;this['_cancelButton']&&(this[_0xea72b5(0x378)][_0xea72b5(0x236)]=ConfigManager[_0xea72b5(0x2ca)]),this[_0xea72b5(0x285)]&&(this['_pageupButton']['visible']=ConfigManager['touchUI']),this[_0xea72b5(0x2f4)]&&(this['_pagedownButton'][_0xea72b5(0x236)]=ConfigManager[_0xea72b5(0x2ca)]);},Scene_Base['prototype'][_0x16899c(0x339)]=function(){const _0x445836=_0x16899c;this[_0x445836(0x378)]&&(this[_0x445836(0x378)]['y']=this['buttonY']()),this[_0x445836(0x285)]&&(this[_0x445836(0x285)]['y']=this['buttonY'](),Graphics['_isFPSCounterOn']()&&!this[_0x445836(0x401)]()&&(this[_0x445836(0x285)]['y']+=0x32)),this['_pagedownButton']&&(this[_0x445836(0x2f4)]['y']=this[_0x445836(0x308)](),Graphics[_0x445836(0x247)]()&&!this[_0x445836(0x401)]()&&(this[_0x445836(0x2f4)]['y']+=0x32));},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x25a)]=Scene_Base[_0x16899c(0x2dd)]['buttonAssistText1'],Scene_Base[_0x16899c(0x2dd)][_0x16899c(0x2ab)]=function(){const _0x47d70f=_0x16899c;return ConfigManager['touchUI']?VisuMZ[_0x47d70f(0x3c1)]['Scene_Base_buttonAssistText1'][_0x47d70f(0x3d3)](this):this['checkActiveWindowPageUpDownHandlers']();},Scene_Base[_0x16899c(0x2dd)]['checkActiveWindowPageUpDownHandlers']=function(){const _0x406768=_0x16899c;if(this[_0x406768(0x3bc)]&&this[_0x406768(0x3bc)]['children'])for(const _0x14d29b of this[_0x406768(0x3bc)][_0x406768(0x373)]){if(!_0x14d29b)continue;if(!_0x14d29b[_0x406768(0x252)])continue;if(!_0x14d29b[_0x406768(0x2a5)])continue;if(_0x14d29b['_handlers']['pageup'])return TextManager['buttonAssistSwitch'];}return'';},VisuMZ['OptionsCore'][_0x16899c(0x317)]=Scene_MenuBase[_0x16899c(0x2dd)][_0x16899c(0x2a9)],Scene_MenuBase[_0x16899c(0x2dd)][_0x16899c(0x2a9)]=function(){const _0xd2d3f5=_0x16899c;VisuMZ[_0xd2d3f5(0x3c1)]['Scene_MenuBase_createPageButtons'][_0xd2d3f5(0x3d3)](this),Graphics[_0xd2d3f5(0x247)]()&&!this['isBottomButtonMode']()&&(this[_0xd2d3f5(0x285)]['y']+=0x32,this[_0xd2d3f5(0x2f4)]['y']+=0x32);},Scene_MenuBase[_0x16899c(0x2dd)]['updateButtonVisibility']=function(){const _0x16639c=_0x16899c;if(!this[_0x16639c(0x378)])this[_0x16639c(0x1f5)]();Scene_Base['prototype'][_0x16639c(0x2c3)][_0x16639c(0x3d3)](this);},VisuMZ['OptionsCore'][_0x16899c(0x2b9)]=Scene_Title[_0x16899c(0x2dd)][_0x16899c(0x369)],Scene_Title[_0x16899c(0x2dd)][_0x16899c(0x369)]=function(){const _0x4b8172=_0x16899c;this[_0x4b8172(0x364)](),VisuMZ[_0x4b8172(0x3c1)][_0x4b8172(0x2b9)][_0x4b8172(0x3d3)](this);},Scene_Title[_0x16899c(0x2dd)][_0x16899c(0x364)]=function(){const _0x3984c5=_0x16899c;if(ConfigManager[_0x3984c5(0x40f)])return;if($gameTemp[_0x3984c5(0x258)]())return;if(Input[_0x3984c5(0x294)](_0x3984c5(0x241)))this[_0x3984c5(0x245)](0x2);if(Input[_0x3984c5(0x294)](_0x3984c5(0x2fb)))this['processOptionsCoreFailsafe'](0x4);if(Input['isTriggered'](_0x3984c5(0x351)))this[_0x3984c5(0x245)](0x6);if(Input['isTriggered']('up'))this[_0x3984c5(0x245)](0x8);},Scene_Title[_0x16899c(0x2dd)]['processOptionsCoreFailsafe']=function(_0x15023b){const _0x332d86=_0x16899c,_0x1c66da=[0x8,0x8,0x2,0x2,0x4,0x6,0x4,0x6];this[_0x332d86(0x3bf)]=this[_0x332d86(0x3bf)]||0x0,_0x15023b===_0x1c66da[this[_0x332d86(0x3bf)]]?this[_0x332d86(0x3bf)]++:this[_0x332d86(0x3bf)]=0x0,this['_optionsCoreFailsafeCheck']===_0x1c66da[_0x332d86(0x2ff)]&&(ConfigManager[_0x332d86(0x40f)]=!![],ConfigManager[_0x332d86(0x341)](),SoundManager[_0x332d86(0x262)]());},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x279)]=Scene_Map[_0x16899c(0x2dd)][_0x16899c(0x356)],Scene_Map[_0x16899c(0x2dd)][_0x16899c(0x356)]=function(){const _0x1f318d=_0x16899c;VisuMZ[_0x1f318d(0x3c1)][_0x1f318d(0x279)][_0x1f318d(0x3d3)](this),ConfigManager['assistMode']&&ConfigManager['assistMapSpeed']&&!$gameMessage[_0x1f318d(0x3e1)]()&&this['updateMainMultiplyOptionsCore']();},Scene_Map['prototype']['updateMainMultiplyOptionsCore']=function(){const _0x29e4b1=_0x16899c;let _0x51ff91=ConfigManager['assistMapSpeed']||0x0;while(_0x51ff91--){this[_0x29e4b1(0x2ec)]();}},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x367)]=Scene_Battle[_0x16899c(0x2dd)][_0x16899c(0x369)],Scene_Battle['prototype']['update']=function(){const _0xe768a8=_0x16899c;VisuMZ[_0xe768a8(0x3c1)][_0xe768a8(0x367)]['call'](this);if(ConfigManager['battleAniSpeed'])this[_0xe768a8(0x331)]();},Scene_Battle[_0x16899c(0x2dd)][_0x16899c(0x331)]=function(){const _0x170643=_0x16899c;if(this[_0x170643(0x2a0)]()){this[_0x170643(0x320)]=!![];let _0xb7de4=ConfigManager['battleAniSpeed'];while(_0xb7de4--){this['update'](),SceneManager[_0x170643(0x3e6)]();}this[_0x170643(0x320)]=![];}},Scene_Battle[_0x16899c(0x2dd)]['allowUpdateBattleAniSpeed']=function(){const _0x18259e=_0x16899c;return!BattleManager[_0x18259e(0x29e)]()&&!this[_0x18259e(0x320)]&&!$gameMessage[_0x18259e(0x3e1)]();},Scene_Options[_0x16899c(0x349)]=VisuMZ['OptionsCore'][_0x16899c(0x277)]['Rebind'][_0x16899c(0x257)]&&Imported[_0x16899c(0x377)]&&VisuMZ[_0x16899c(0x3aa)]['version']>1.65,Scene_Options['prototype'][_0x16899c(0x363)]=function(){return 0x0;},Scene_Options[_0x16899c(0x2dd)]['isUseModernControls']=function(){const _0x388059=_0x16899c;return this[_0x388059(0x2c4)]&&this[_0x388059(0x2c4)]['isUseModernControls']();},Scene_Options[_0x16899c(0x2dd)][_0x16899c(0x2cb)]=function(){const _0x3dd271=_0x16899c;Scene_MenuBase[_0x3dd271(0x2dd)]['create'][_0x3dd271(0x3d3)](this),this[_0x3dd271(0x22c)](),this['createOptionsWindow'](),this[_0x3dd271(0x313)]();if(Imported[_0x3dd271(0x377)]){}this[_0x3dd271(0x3d5)]();},Scene_Options[_0x16899c(0x2dd)]['createCategoryWindow']=function(){const _0x2f7c79=_0x16899c,_0x13ecb7=this[_0x2f7c79(0x1fb)]();this['_categoryWindow']=new Window_OptionsCategory(_0x13ecb7),this[_0x2f7c79(0x217)](this[_0x2f7c79(0x2c4)]),!this[_0x2f7c79(0x303)]()&&(this[_0x2f7c79(0x2c4)][_0x2f7c79(0x34c)]('category',this['commandCategory'][_0x2f7c79(0x1f6)](this)),this[_0x2f7c79(0x2c4)][_0x2f7c79(0x34c)](_0x2f7c79(0x284),this['popScene'][_0x2f7c79(0x1f6)](this)));},Scene_Options[_0x16899c(0x2dd)][_0x16899c(0x1fb)]=function(){const _0x3ad45b=_0x16899c,_0x94b4d0=Graphics['boxWidth'],_0x5d8ceb=this[_0x3ad45b(0x30e)](0x1,!![]),_0x3fb21b=0x0,_0x4bf909=this[_0x3ad45b(0x2aa)]();return new Rectangle(_0x3fb21b,_0x4bf909,_0x94b4d0,_0x5d8ceb);},Scene_Options[_0x16899c(0x2dd)][_0x16899c(0x36f)]=function(){const _0x5a75b1=_0x16899c,_0x5bab93=this[_0x5a75b1(0x309)]();this[_0x5a75b1(0x380)]=new Window_Options(_0x5bab93),this[_0x5a75b1(0x217)](this['_optionsWindow']),this[_0x5a75b1(0x380)][_0x5a75b1(0x34c)](_0x5a75b1(0x284),this[_0x5a75b1(0x2e3)]['bind'](this)),this[_0x5a75b1(0x2c4)][_0x5a75b1(0x23d)](this[_0x5a75b1(0x380)]),this[_0x5a75b1(0x303)]()?(this[_0x5a75b1(0x380)]['activate'](),this[_0x5a75b1(0x380)][_0x5a75b1(0x2ef)](0x0)):(this['_optionsWindow']['deactivate'](),this[_0x5a75b1(0x380)][_0x5a75b1(0x350)]());},Scene_Options['prototype']['optionsWindowRect']=function(){const _0x1b0ce2=_0x16899c,_0x3c41d7=Graphics[_0x1b0ce2(0x3e2)],_0x4693bc=this[_0x1b0ce2(0x253)]()-this[_0x1b0ce2(0x2c4)][_0x1b0ce2(0x3f6)],_0x55fbc5=0x0,_0x4768e0=this[_0x1b0ce2(0x2c4)]['y']+this[_0x1b0ce2(0x2c4)][_0x1b0ce2(0x3f6)];return new Rectangle(_0x55fbc5,_0x4768e0,_0x3c41d7,_0x4693bc);},Scene_Options[_0x16899c(0x2dd)][_0x16899c(0x313)]=function(){const _0x5b7727=_0x16899c;if($gameTemp[_0x5b7727(0x375)]!==undefined){const _0x1bdc2e=$gameTemp['_returnOptionsCore'];this[_0x5b7727(0x2c4)][_0x5b7727(0x2ef)](_0x1bdc2e[_0x5b7727(0x348)]),this['_categoryWindow'][_0x5b7727(0x369)](),this[_0x5b7727(0x303)]()?this['_categoryWindow'][_0x5b7727(0x407)]():this[_0x5b7727(0x2c4)][_0x5b7727(0x26c)](),this[_0x5b7727(0x380)]['activate'](),this['_optionsWindow']['_index']=_0x1bdc2e[_0x5b7727(0x3d6)],this[_0x5b7727(0x380)][_0x5b7727(0x3c9)]=_0x1bdc2e['scrollX'],this[_0x5b7727(0x380)][_0x5b7727(0x219)]=_0x1bdc2e[_0x5b7727(0x36b)],this[_0x5b7727(0x380)][_0x5b7727(0x2cd)]=0x0,this[_0x5b7727(0x380)]['refreshCursor'](),this[_0x5b7727(0x380)][_0x5b7727(0x369)](),$gameTemp[_0x5b7727(0x375)]=undefined;}},Scene_Options[_0x16899c(0x2dd)][_0x16899c(0x402)]=function(){const _0x73b88c=_0x16899c;this[_0x73b88c(0x380)]['activate'](),this[_0x73b88c(0x380)][_0x73b88c(0x2ef)](0x0);},Scene_Options[_0x16899c(0x2dd)][_0x16899c(0x2e3)]=function(){const _0xf5aa50=_0x16899c;this['isUseModernControls']()?this[_0xf5aa50(0x224)]():(this[_0xf5aa50(0x2c4)]['activate'](),this[_0xf5aa50(0x380)][_0xf5aa50(0x350)]());},Scene_Options[_0x16899c(0x2dd)]['optionsCoreUpdateButtonPositions']=function(){const _0x501ff5=_0x16899c;Scene_MenuBase[_0x501ff5(0x2dd)][_0x501ff5(0x339)]['call'](this),this[_0x501ff5(0x379)]();},Scene_Options[_0x16899c(0x2dd)][_0x16899c(0x379)]=function(){const _0x38dead=_0x16899c;if(this['_categoryWindow']){const _0x549c80=this[_0x38dead(0x1fb)]();this[_0x38dead(0x2c4)][_0x38dead(0x334)](_0x549c80['x'],_0x549c80['y'],_0x549c80['width'],_0x549c80[_0x38dead(0x3f6)]);}if(this[_0x38dead(0x380)]){const _0x4c975b=this[_0x38dead(0x309)]();this[_0x38dead(0x380)][_0x38dead(0x334)](_0x4c975b['x'],_0x4c975b['y'],_0x4c975b[_0x38dead(0x243)],_0x4c975b[_0x38dead(0x3f6)]);}if(this['_buttonAssistWindow']){const _0xee89c6=this[_0x38dead(0x306)]();this['_buttonAssistWindow']['move'](_0xee89c6['x'],_0xee89c6['y'],_0xee89c6['width'],_0xee89c6['height']),this[_0x38dead(0x2b0)]['refresh']();}this['refreshWindows']();},Scene_Options[_0x16899c(0x2dd)]['buttonAssistText1']=function(){const _0x1f42ac=_0x16899c;return VisuMZ[_0x1f42ac(0x3c1)]['Settings']['OptionsSettings']['buttonAssistCategory'];},Scene_Options['prototype'][_0x16899c(0x301)]=function(){const _0x36dcbe=_0x16899c;this[_0x36dcbe(0x2c4)]&&(this['_categoryWindow']['refresh'](),this[_0x36dcbe(0x2c4)][_0x36dcbe(0x2d1)]()),this[_0x36dcbe(0x380)]&&(this[_0x36dcbe(0x380)][_0x36dcbe(0x38e)](),this['_optionsWindow'][_0x36dcbe(0x2d1)]()),this[_0x36dcbe(0x2b0)]&&this['_buttonAssistWindow']['refresh']();},Scene_Options[_0x16899c(0x2dd)][_0x16899c(0x260)]=function(){const _0x5248c4=_0x16899c,_0x515013=Scene_Options[_0x5248c4(0x393)][_0x5248c4(0x3ac)]||0x0,_0xa326c1=[this[_0x5248c4(0x2c4)],this[_0x5248c4(0x380)],this[_0x5248c4(0x2b0)]];for(const _0x39c6cf of _0xa326c1){if(_0x39c6cf)_0x39c6cf[_0x5248c4(0x336)](_0x515013);}},Scene_Options[_0x16899c(0x2dd)][_0x16899c(0x3d5)]=function(){const _0x40d29a=_0x16899c,_0xe94a4d=VisuMZ[_0x40d29a(0x3c1)][_0x40d29a(0x277)][_0x40d29a(0x33b)];if(this[_0x40d29a(0x2c4)]){const _0x2a0664=_0xe94a4d[_0x40d29a(0x216)]??0x0;this[_0x40d29a(0x2c4)][_0x40d29a(0x336)](_0x2a0664);}if(this['_optionsWindow']){const _0x32d165=_0xe94a4d[_0x40d29a(0x38d)]??0x0;this[_0x40d29a(0x380)][_0x40d29a(0x336)](_0x32d165);}if(this['_buttonAssistWindow']){const _0x5bf74d=_0xe94a4d[_0x40d29a(0x2dc)]??0x0;this[_0x40d29a(0x2b0)]['setBackgroundType'](_0x5bf74d);}};function Scene_RebindBase(){const _0x18005d=_0x16899c;this[_0x18005d(0x3ea)](...arguments);}Scene_RebindBase[_0x16899c(0x2dd)]=Object[_0x16899c(0x2cb)](Scene_MenuBase['prototype']),Scene_RebindBase[_0x16899c(0x2dd)]['constructor']=Scene_RebindBase,Scene_RebindBase[_0x16899c(0x21a)]={'helpBgType':VisuMZ['OptionsCore'][_0x16899c(0x277)][_0x16899c(0x2e9)][_0x16899c(0x23c)]??0x0,'inputBgType':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)][_0x16899c(0x2e9)][_0x16899c(0x39c)]??0x0},Scene_RebindBase[_0x16899c(0x2dd)][_0x16899c(0x3ea)]=function(){const _0xbe8ea1=_0x16899c;Scene_MenuBase[_0xbe8ea1(0x2dd)]['initialize'][_0xbe8ea1(0x3d3)](this),document['addEventListener']('keydown',this[_0xbe8ea1(0x264)][_0xbe8ea1(0x1f6)](this));if(!Imported[_0xbe8ea1(0x377)]){let _0x59009e='This\x20feature\x20requires\x20VisuMZ_0_CoreEngine\x20to\x20work!';alert(_0x59009e),SceneManager[_0xbe8ea1(0x406)]();}else{if(VisuMZ[_0xbe8ea1(0x3aa)][_0xbe8ea1(0x371)]<1.8){let _0xd3255b='';_0xd3255b+=_0xbe8ea1(0x296),_0xd3255b+=_0xbe8ea1(0x237),alert(_0xd3255b),SceneManager[_0xbe8ea1(0x406)]();}}},Scene_RebindBase['prototype'][_0x16899c(0x29f)]=function(){const _0x3c033b=_0x16899c;return TextManager[_0x3c033b(0x288)](_0x3c033b(0x21e));},Scene_RebindBase[_0x16899c(0x2dd)][_0x16899c(0x2da)]=function(){const _0xa971d=_0x16899c;return Window_KeyRebinds['SETTINGS'][_0xa971d(0x343)][_0xa971d(0x1ea)];},Scene_RebindBase[_0x16899c(0x2dd)]['buttonAssistText4']=function(){const _0x5adf0f=_0x16899c;return Window_KeyRebinds[_0x5adf0f(0x21a)][_0x5adf0f(0x343)][_0x5adf0f(0x3c8)];},Scene_RebindBase[_0x16899c(0x2dd)][_0x16899c(0x3d7)]=function(){const _0x44b9d4=_0x16899c;return Window_KeyRebinds[_0x44b9d4(0x21a)][_0x44b9d4(0x343)][_0x44b9d4(0x284)];},Scene_RebindBase[_0x16899c(0x2dd)]['create']=function(){const _0x5c31bf=_0x16899c;Scene_MenuBase['prototype']['create'][_0x5c31bf(0x3d3)](this),this[_0x5c31bf(0x3ca)](),this['createRebindWindow'](),this[_0x5c31bf(0x2ee)]();},Scene_RebindBase['prototype'][_0x16899c(0x3ca)]=function(){const _0x35a1ec=_0x16899c;Scene_MenuBase[_0x35a1ec(0x2dd)]['createHelpWindow'][_0x35a1ec(0x3d3)](this),this['_helpWindow'][_0x35a1ec(0x336)](Scene_RebindBase[_0x35a1ec(0x21a)]['helpBgType']);},Scene_RebindBase[_0x16899c(0x2dd)][_0x16899c(0x2c2)]=function(){const _0x7d8f70=_0x16899c,_0x5f381d=this[_0x7d8f70(0x26f)](),_0x342a31=new Window_KeyRebinds(_0x5f381d);this['addWindow'](_0x342a31),_0x342a31[_0x7d8f70(0x34c)](_0x7d8f70(0x352),this[_0x7d8f70(0x381)][_0x7d8f70(0x1f6)](this)),_0x342a31[_0x7d8f70(0x34c)](_0x7d8f70(0x284),this['popScene'][_0x7d8f70(0x1f6)](this)),_0x342a31[_0x7d8f70(0x31b)](this[_0x7d8f70(0x3f2)]),_0x342a31[_0x7d8f70(0x336)](Window_KeyRebinds['SETTINGS'][_0x7d8f70(0x315)]),this[_0x7d8f70(0x411)]=_0x342a31;},Scene_RebindBase[_0x16899c(0x2dd)]['rebindWindowRect']=function(){const _0x10f829=_0x16899c;if(VisuMZ[_0x10f829(0x3c1)][_0x10f829(0x277)][_0x10f829(0x2e9)][_0x10f829(0x28a)])return VisuMZ[_0x10f829(0x3c1)][_0x10f829(0x277)][_0x10f829(0x2e9)][_0x10f829(0x28a)][_0x10f829(0x3d3)](this);const _0x561443=0x30,_0x43a3f8=Math[_0x10f829(0x3a2)]((Graphics[_0x10f829(0x3e2)]-_0x561443*0x2)*(this[_0x10f829(0x1eb)]()?0x2/0x3:0x1)),_0x72c2e1=this[_0x10f829(0x253)]()-_0x561443*0x2,_0x367fc0=Math[_0x10f829(0x3b3)]((Graphics['boxWidth']-_0x43a3f8)/0x2),_0x1c3f69=this['mainAreaTop']()+Math[_0x10f829(0x3b3)]((this['mainAreaHeight']()-_0x72c2e1)/0x2);return new Rectangle(_0x367fc0,_0x1c3f69,_0x43a3f8,_0x72c2e1);},Scene_RebindBase[_0x16899c(0x2dd)]['isForKeyboard']=function(){return![];},Scene_RebindBase['prototype'][_0x16899c(0x1eb)]=function(){return![];},Scene_RebindBase[_0x16899c(0x2dd)][_0x16899c(0x2ee)]=function(){const _0x130ff9=_0x16899c,_0x1498d9=this['inputMsgWindowRect'](),_0x209cc2=new Window_RebindHelp(_0x1498d9);this[_0x130ff9(0x3c4)](_0x209cc2),_0x209cc2['openness']=0x0,_0x209cc2[_0x130ff9(0x336)](Scene_RebindBase['SETTINGS'][_0x130ff9(0x32a)]),this[_0x130ff9(0x2e7)]=_0x209cc2;},Scene_RebindBase['prototype'][_0x16899c(0x3ef)]=function(){const _0x32fb93=_0x16899c;if(VisuMZ[_0x32fb93(0x3c1)][_0x32fb93(0x277)][_0x32fb93(0x2e9)][_0x32fb93(0x239)])return VisuMZ['OptionsCore']['Settings'][_0x32fb93(0x2e9)]['HelpRebindWindow_RectJS'][_0x32fb93(0x3d3)](this);const _0x48a440=Math[_0x32fb93(0x3a2)](Graphics[_0x32fb93(0x3e2)]*0x2/0x3),_0x47789d=this[_0x32fb93(0x30e)](0x2,![]),_0x29d64b=Math['floor']((Graphics[_0x32fb93(0x3e2)]-_0x48a440)/0x2),_0x4f43c1=Math[_0x32fb93(0x3b3)]((Graphics[_0x32fb93(0x3cf)]-_0x47789d)/0x2);return new Rectangle(_0x29d64b,_0x4f43c1,_0x48a440,_0x47789d);},Scene_RebindBase['prototype'][_0x16899c(0x381)]=function(){const _0x50a20e=_0x16899c;Input[_0x50a20e(0x2c1)](),TouchInput[_0x50a20e(0x2c1)](),this['_helpWindow']['clear'](),this[_0x50a20e(0x2e7)]['open'](),this[_0x50a20e(0x2e7)][_0x50a20e(0x26d)](this[_0x50a20e(0x3fe)]());},Scene_RebindBase[_0x16899c(0x2dd)][_0x16899c(0x3fe)]=function(){return'-';},Scene_RebindBase[_0x16899c(0x2dd)][_0x16899c(0x264)]=function(_0x1383bb){const _0x2a5f97=_0x16899c;this[_0x2a5f97(0x2e7)]['isOpen']()&&(Input[_0x2a5f97(0x2c1)](),TouchInput[_0x2a5f97(0x2c1)](),this['processEventKeyDown'](_0x1383bb));},Scene_RebindBase['prototype'][_0x16899c(0x307)]=function(_0x2e4ee7){const _0xa79643=_0x16899c,_0x4853ef=_0x2e4ee7[_0xa79643(0x1f2)];if(_0x4853ef===0x1b)this['cancelRebinding']();else{if(this[_0xa79643(0x281)]()&&this[_0xa79643(0x2cc)](_0x4853ef))this[_0xa79643(0x3a5)]();else this[_0xa79643(0x281)]()&&this['processKeybind'](_0x4853ef);}},Scene_RebindBase[_0x16899c(0x2dd)][_0x16899c(0x3f1)]=function(){const _0x1960ee=_0x16899c;SoundManager[_0x1960ee(0x33f)](),this['_inputMsgWindow'][_0x1960ee(0x23a)](),this[_0x1960ee(0x411)][_0x1960ee(0x407)](),this[_0x1960ee(0x411)][_0x1960ee(0x38e)]();},Scene_RebindBase[_0x16899c(0x2dd)][_0x16899c(0x2cc)]=function(_0x38f853){return!![];},Scene_RebindBase[_0x16899c(0x2dd)]['playErrorKeybind']=function(){const _0x42fe09=_0x16899c;SoundManager[_0x42fe09(0x3b9)]();const _0x5e72c2=Window_KeyRebinds[_0x42fe09(0x21a)][_0x42fe09(0x35b)][_0x42fe09(0x1f4)];this[_0x42fe09(0x2e7)][_0x42fe09(0x26d)](_0x5e72c2);},Scene_RebindBase[_0x16899c(0x2dd)][_0x16899c(0x1f8)]=function(_0x619ceb){const _0xfaf28f=_0x16899c;this[_0xfaf28f(0x397)](_0x619ceb),$gameMap[_0xfaf28f(0x28c)](),Input['clear'](),TouchInput[_0xfaf28f(0x2c1)](),SoundManager[_0xfaf28f(0x340)](),this[_0xfaf28f(0x2e7)][_0xfaf28f(0x23a)](),this['_rebindWindow'][_0xfaf28f(0x407)](),this['_rebindWindow'][_0xfaf28f(0x38e)](),ConfigManager[_0xfaf28f(0x341)]();};function _0x525f(){const _0x4e7608=['_requestFullScreen','onListCancel','VisuMZ_3_ButtonTriggerEvts\x20needs\x20to\x20be\x20updated\x20','textFont','Scene_RebindGamepad','_inputMsgWindow','hasEncounterHalf','Rebind','setCategory','Switch\x20Left','updateMain','pageup','createInputMsgWindow','smoothSelect','mainFontFace','createTextState','ARRAYSTRUCT','iconHeight','_pagedownButton','style','gamepad','ConvertParams','_text','makeRebindSave','VisuMZ_4_ButtonCmnEvts\x20needs\x20to\x20be\x20updated\x20','left','outputWidth','processVolumeShortcut','commandStyle','length','keyOrder','refreshWindows','assistGodmode','isUseModernControls','Window_Options_processOk','_fullScreenOptionsCore','buttonAssistWindowRect','processEventKeyDown','buttonY','optionsWindowRect','Game_Troop_expTotal','changeMasterVolumeViaShortcut','enabled','MasterVolShortcut','calcWindowHeight','match','resetFontSettings','map','gamepadOrder','postCreateWindows','drawText','bgType','currentData','Scene_MenuBase_createPageButtons','findControllerInputRebindMatch','noGamepadFound','Confirm','setHelpWindow','Symbol','updateOptionsCoreScene','addKeyboardColumns','isCancelled','_battleAniSpeedLooping','ext','playCursorSound','playMasterVolumeUp','makeCommandList','rebindControllerInputButtonString','showFauxAnimations','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','assistRandomEncounters','STR','inputBgType','displayFPS','ButtonTriggerEvts','hoverEnabled','seOK','_bypassForRebindController','drawBackgroundRect','updateBattleAniSpeed','2437896LcpSLe','buzzerSFXs','move','pressKeyboard','setBackgroundType','cancelSFXs','playOk','optionsCoreUpdateButtonPositions','iconText','OptionsSettings','innerWidth','_loading','escape','playCancel','playEquip','save','TextStr','buttonAssist','mhp','updateHelp','max','itemLineRect','category','ADD_REBIND_OPTIONS','processOptionsCoreSoundEffects','categories','setHandler','5518400fNoqzB','DashToggleR','Game_BattlerBase_isStateResist','deselect','right','rebind','0abCdefghijklmnopqrstuvwxyz','499855knjYoD','processAllText','updateMainMultiply','setupType','cursorPagedown','buttonFmt','downPitch','helpText','Select\x20a\x20button\x20to\x20rebind/change.','change','Input_updateGamepadState','_list','setWindowTone','drawTextEx','parameters','helpAreaHeight','updateOptionsCoreFailsafe','_scene','applySavedRebinds','Scene_Battle_update','goldRate','update','none','scrollY','commandNameWindowDrawText','dpadFmt','assistResistNegatives','createOptionsWindow','assistGoldMultiplier','version','return\x200','children','\x5cI[%1]%2','_returnOptionsCore','windowTone','VisuMZ_0_CoreEngine','_cancelButton','optionsCoreUpdateWindowPositions','Graphics_switchFullScreen','keyMapper','Game_Battler_useItem','ShowJS','commandName','Match','_optionsWindow','startRebind','isCursorMovable','REBIND','_windowTone','tab','Window_Options_cursorLeft','stringKeyMap','SoundManager_playCancel','contents','VisuMZ_1_SkillsStatesCore','reset','switchModeOptionsCore','optionsWindowBgType','refresh','FUNC','seCancel','27814610LrjUFd','InputPosition','layoutSettings','Game_Party_hasEncounterHalf','end','getKeyName','updateKeybinds','alwaysDash','ModernControls','text','seBuzzer','HelpRebindWindow_BgType','downName','selectKeyboard','_lastGamepadState','_lastGamepadID','deathStateId','ceil','Select\x20a\x20key\x20to\x20rebind/change.','Graphics_requestFullScreen','playErrorKeybind','cursorSFXs','center','Icon','Input_isTriggered','CoreEngine','_dataFunc','OptionsBgType','_cancelFullScreen','Window_Options_initialize','playMasterVolumeDown','LoadJS','opacity','uiHelpPosition','floor','callUpdateHelp','TextManager_getControllerInputButtonString','description','_gamepadStates','pressGamepad','playBuzzer','dashToggle','_stretchScreenOptionsCore','_windowLayer','prepareOptionsCoreSceneChange','_currentDrawingIndex','_optionsCoreFailsafeCheck','categoryList','OptionsCore','4qaKGhY','ControllerMatches','addChild','\x5c}Button\x5c{\x20%1','onDatabaseLoaded','innerHeight','confirm','_scrollX','createHelpWindow','clamp','drawItemKeyName','setMasterVolume','SoundManager_playBuzzer','boxHeight','symbol','CategoryStyle','toUpperCase','call','name','updateOptionsSceneBgTypes','index','buttonAssistText5','uiMenuStyle','SoundManager_playOk','onTouchSelect','switchMode','initOptionsCore','CursorRightJS','Game_Action_executeHpDamage','drawItemStyleIconText','process_VisuMZ_OptionsCore_DefaultLoad','isBusy','boxWidth','keyName','_doubleTouch','removeAssist','updateEffekseer','addCommand','CategoryTextAlign','updateWindowPositions','initialize','Window_Options_cursorRight','JSON','showRegularAnimations','makeData','inputMsgWindowRect','addDebuff','cancelRebinding','_helpWindow','Input_isRepeated','isGamepadConnected','format','height','makeDeepCopy','VolumeShortcut','fullScreen','replace','onTouchOk','changePaintOpacity','_commandNameWindow','inputKeyboardMessage','button%1','playSe','isBottomButtonMode','commandCategory','start','applyData','executeHpDamage','exit','activate','requestAnimation','ARRAYFUNC','paintOpacity','DataManager_setupNewGame','masterVolume','Switch\x20Right','hasEncounterNone','assistMode','Name','_rebindWindow','\x22//\x20Return\x20Boolean\x5cnreturn\x20!$gameTemp.isPlaytest()\x20&&\x20ConfigManager.assistMode;\x22','remove','isForGamepad','STRUCT','select','processCursorMoveModernControls','1151817XNpAPy','That\x20key\x20cannot\x20be\x20bound\x20to\x20a\x20control.','917HqgMzt','keyCode','icon','pressForbidden','createButtons','bind','shiftReset','processKeybind','playCursor','ConfigManager_applyData','categoryWindowRect','Down','seCursor','cursorUp','battleAniShow','drawItemKeyRebind','playOkSound','downVolume','upName','Game_System_initialize','updateShiftRemoveShortcut','ConfigManager_makeData','uiButtonPosition','display','createCommandNameWindow','DefaultJS','updateCommandNameWindow','makeDataOptionsCore','isOptionValid','getKeyboardMappingByKeyType','ARRAYNUM','assistSkillCosts','FPSCounter','commandRemember','_stretchEnabled','test','shiftRemove','categoryWindowBgType','addWindow','status','_scrollY','SETTINGS','CursorLeftJS','Untitled','_switchFullScreen','shift','CheckAmPresent','KeyboardInput','VisuMZ_4_ButtonCmnEvts','SoundManager_playCursor','Categories','popScene','SFXBuzzerList','[\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Effects\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistMode\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2287\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Playtest\x20Effects\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x5cnthis.refresh();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.refresh();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.refresh();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20false;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Exploration\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistMapSpeed\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2282\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Map\x20Update\x20Speed\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20segment\x20=\x20halfWidth\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Segments\x5c\x5c\x5c\x5cnconst\x20speedText\x20=\x20[\x27Normal\x27,\x20\x27Fast\x27,\x20\x27Faster\x27,\x20\x27Fastest\x27];\x5c\x5c\x5c\x5cnfor\x20(let\x20i\x20=\x200;\x20i\x20<\x204;\x20i++)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.changePaintOpacity(i\x20===\x20value);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20const\x20text\x20=\x20speedText[i];\x5c\x5c\x5c\x5cn\x20\x20\x20\x20const\x20sx\x20=\x20rect.x\x20+\x20halfWidth\x20+\x20(segment\x20*\x20i);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.drawText(text,\x20sx,\x20rect.y,\x20segment,\x20\x27center\x27);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x203\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x203);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x203);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x203);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x203);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x203);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistRandomEncounters\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2276\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Random\x20Encounters\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20segment\x20=\x20halfWidth\x20/\x203;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Segments\x5c\x5c\x5c\x5cnconst\x20speedText\x20=\x20[\x27None\x27,\x20\x27Half\x27,\x20\x27Normal\x27];\x5c\x5c\x5c\x5cnfor\x20(let\x20i\x20=\x200;\x20i\x20<\x203;\x20i++)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.changePaintOpacity(i\x20===\x20value);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20const\x20text\x20=\x20speedText[i];\x5c\x5c\x5c\x5cn\x20\x20\x20\x20const\x20sx\x20=\x20rect.x\x20+\x20halfWidth\x20+\x20(segment\x20*\x20i);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.drawText(text,\x20sx,\x20rect.y,\x20segment,\x20\x27center\x27);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x202\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x202);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x202);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x202);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x202;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x202);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x202);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Battle\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistGodmode\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22God\x20Mode\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20false;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistResistNegatives\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Resist\x20Negative\x20Effects\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode\x20&&\x20Imported.VisuMZ_1_SkillsStatesCore;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20false;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistInstantKO\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Instant\x20K.O.\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20false;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistSkillCosts\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Skill\x20Costs\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistConsumeItems\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Consume\x20Items\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Rewards\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistExpMultiplier\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2288\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22EXP\x20Multiplier\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Gauge\x5c\x5c\x5c\x5cnconst\x20rate\x20=\x20(value\x20/\x2010).clamp(0,\x201);\x5c\x5c\x5c\x5cnconst\x20gx\x20=\x20rect.x\x20+\x20halfWidth;\x5c\x5c\x5c\x5cnconst\x20gy\x20=\x20rect.y\x20+\x20rect.height\x20-\x2014;\x5c\x5c\x5c\x5cnconst\x20fillW\x20=\x20Math.floor((halfWidth\x20-\x202)\x20*\x20rate);\x5c\x5c\x5c\x5cnconst\x20color0\x20=\x20ColorManager.gaugeBackColor();\x5c\x5c\x5c\x5cnconst\x20color1\x20=\x20ColorManager.textColor(30);\x5c\x5c\x5c\x5cnconst\x20color2\x20=\x20ColorManager.textColor(31);\x5c\x5c\x5c\x5cnthis.contents.fillRect(gx,\x20gy,\x20halfWidth,\x2012,\x20color0);\x5c\x5c\x5c\x5cnthis.contents.gradientFillRect(gx\x20+\x201,\x20gy\x20+\x201,\x20fillW,\x2010,\x20color1,\x20color2);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Value\x5c\x5c\x5c\x5cnconst\x20text\x20=\x20\x27x%1\x27.format(2\x20**\x20value);\x5c\x5c\x5c\x5cnthis.drawText(text,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x2010\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistGoldMultiplier\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x22314\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Gold\x20Multiplier\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Gauge\x5c\x5c\x5c\x5cnconst\x20rate\x20=\x20(value\x20/\x2010).clamp(0,\x201);\x5c\x5c\x5c\x5cnconst\x20gx\x20=\x20rect.x\x20+\x20halfWidth;\x5c\x5c\x5c\x5cnconst\x20gy\x20=\x20rect.y\x20+\x20rect.height\x20-\x2014;\x5c\x5c\x5c\x5cnconst\x20fillW\x20=\x20Math.floor((halfWidth\x20-\x202)\x20*\x20rate);\x5c\x5c\x5c\x5cnconst\x20color0\x20=\x20ColorManager.gaugeBackColor();\x5c\x5c\x5c\x5cnconst\x20color1\x20=\x20ColorManager.textColor(14);\x5c\x5c\x5c\x5cnconst\x20color2\x20=\x20ColorManager.textColor(6);\x5c\x5c\x5c\x5cnthis.contents.fillRect(gx,\x20gy,\x20halfWidth,\x2012,\x20color0);\x5c\x5c\x5c\x5cnthis.contents.gradientFillRect(gx\x20+\x201,\x20gy\x20+\x201,\x20fillW,\x2010,\x20color1,\x20color2);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Value\x5c\x5c\x5c\x5cnconst\x20text\x20=\x20\x27x%1\x27.format(2\x20**\x20value);\x5c\x5c\x5c\x5cnthis.drawText(text,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x2010\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistDropMultiplier\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x22176\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Drop\x20Multiplier\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Gauge\x5c\x5c\x5c\x5cnconst\x20rate\x20=\x20(value\x20/\x2010).clamp(0,\x201);\x5c\x5c\x5c\x5cnconst\x20gx\x20=\x20rect.x\x20+\x20halfWidth;\x5c\x5c\x5c\x5cnconst\x20gy\x20=\x20rect.y\x20+\x20rect.height\x20-\x2014;\x5c\x5c\x5c\x5cnconst\x20fillW\x20=\x20Math.floor((halfWidth\x20-\x202)\x20*\x20rate);\x5c\x5c\x5c\x5cnconst\x20color0\x20=\x20ColorManager.gaugeBackColor();\x5c\x5c\x5c\x5cnconst\x20color1\x20=\x20ColorManager.textColor(11);\x5c\x5c\x5c\x5cnconst\x20color2\x20=\x20ColorManager.textColor(3);\x5c\x5c\x5c\x5cnthis.contents.fillRect(gx,\x20gy,\x20halfWidth,\x2012,\x20color0);\x5c\x5c\x5c\x5cnthis.contents.gradientFillRect(gx\x20+\x201,\x20gy\x20+\x201,\x20fillW,\x2010,\x20color1,\x20color2);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Value\x5c\x5c\x5c\x5cnconst\x20text\x20=\x20\x27x%1\x27.format(2\x20**\x20value);\x5c\x5c\x5c\x5cnthis.drawText(text,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x2010\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Spawners\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistSpawnItems\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x22176\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Spawn\x20Items\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Spawn\x20Items\x5c\x5c\x5c\x5cnconst\x20goods\x20=\x20[];\x5c\x5c\x5c\x5cnfor\x20(const\x20item\x20of\x20$dataItems)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20if\x20(item\x20&&\x20item.name.trim()\x20!==\x20\x27\x27)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20\x20\x20\x20\x20goods.push([0,\x20item.id,\x201,\x200]);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20}\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnSceneManager.push(Scene_Shop);\x5c\x5c\x5c\x5cnSceneManager.prepareNextScene(goods,\x20true);\x5c\x5c\x5c\x5cnthis.prepareOptionsCoreSceneChange();\x5c\x5c\x5c\x5cnSoundManager.playOk();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistSpawnWeapons\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Spawn\x20Weapons\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Spawn\x20Items\x5c\x5c\x5c\x5cnconst\x20goods\x20=\x20[];\x5c\x5c\x5c\x5cnfor\x20(const\x20item\x20of\x20$dataWeapons)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20if\x20(item\x20&&\x20item.name.trim()\x20!==\x20\x27\x27)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20\x20\x20\x20\x20goods.push([1,\x20item.id,\x201,\x200]);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20}\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnSceneManager.push(Scene_Shop);\x5c\x5c\x5c\x5cnSceneManager.prepareNextScene(goods,\x20true);\x5c\x5c\x5c\x5cnthis.prepareOptionsCoreSceneChange();\x5c\x5c\x5c\x5cnSoundManager.playOk();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistSpawnArmors\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x22137\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Spawn\x20Armors\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Spawn\x20Items\x5c\x5c\x5c\x5cnconst\x20goods\x20=\x20[];\x5c\x5c\x5c\x5cnfor\x20(const\x20item\x20of\x20$dataArmors)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20if\x20(item\x20&&\x20item.name.trim()\x20!==\x20\x27\x27)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20\x20\x20\x20\x20goods.push([2,\x20item.id,\x201,\x200]);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20}\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnSceneManager.push(Scene_Shop);\x5c\x5c\x5c\x5cnSceneManager.prepareNextScene(goods,\x20true);\x5c\x5c\x5c\x5cnthis.prepareOptionsCoreSceneChange();\x5c\x5c\x5c\x5cnSoundManager.playOk();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Debug\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistCallDebug\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2289\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Debug\x20Menu\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Call\x20Debug\x20Menu\x5c\x5c\x5c\x5cnSceneManager.push(Scene_Debug);\x5c\x5c\x5c\x5cnthis.prepareOptionsCoreSceneChange();\x5c\x5c\x5c\x5cnSoundManager.playOk();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22]','setupNewGame','SFXCancelList','Scene_RebindKeyboard','ConfigManager_save','useItem','createCategoryWindow','isBottomHelpMode','expTotal','resetAssist','_updateGamepadState','Game_System_mainFontFace','menu','selectGamepad','subject','playBuzzerSound','visible','in\x20order\x20for\x20key\x20rebinds\x20to\x20work.','bgsVolume','HelpRebindWindow_RectJS','close','_saving','HelpWindow_BgType','setListWindow','_masterVolume','smoothScrollTo','uiInputPosition','down','ARRAYJSON','width','Dash','processOptionsCoreFailsafe','Right','_isFPSCounterOn','reassignCoreEngineControls','CheckCompatibility','isOpenAndActive','_rebindState','_replaceKeyID','playStaticSe','isEnemy','_fpsCounter','assistConsumeItems','QoL','active','mainAreaHeight','NUM','processOk','toLowerCase','EnableRebind','isPlaytest','ProcessOkJS','Scene_Base_buttonAssistText1','process_VisuMZ_OptionsCore_ControllerButtons','maxCols','in\x20order\x20for\x20VisuMZ_1_OptionsCore\x20to\x20work.','updateGamepadChange','ButtonPosition','updateCoreEngineOptionsCoreWindowBgStyle','drawItemStyleIcon','playLoad','2jHySSs','onKeyDown','NEGATIVE','No\x20gamepad\x20is\x20detected!','itemRect','EnableJS','isHoverEnabled','Game_Enemy_dropItemRate','getLastUsedGamepadType','deactivate','setText','isActor','rebindWindowRect','canRebindInput','Cancel','12104280YkUPEp','cursorDown','assistExpMultiplier','isCommandEnabled','cursorLeft','Settings','gamepadReset','Scene_Map_updateMainMultiply','Remove','trim','_type','commandNameWindowCenter','Reset','List','windowPadding','isForKeyboard','isRebindingEnabled','Game_Battler_addDebuff','cancel','_pageupButton','Scene_Boot_start','cancelAssist','getInputButtonString','Scene_Boot_onDatabaseLoaded','RebindWindow_RectJS','getControllerInputButtonString','requestRefresh','stretchScreen','_name','keyboard','okSFXs','includes','uiHoverSelect','drawItem','isTriggered','process_VisuMZ_OptionsCore_Failsafe','VisuMZ_0_CoreEngine\x20needs\x20to\x20be\x20updated\x20','round','optionsCoreFonts','auto','assistInstantKO','Game_Temp_showFauxAnimations','isOpen','onTouchSelectModern','isInputting','buttonAssistKey3','allowUpdateBattleAniSpeed','dropItemRate','upPitch','Game_Troop_goldRate','pagedown','_handlers','isStateResist','48930XHefoQ','isPressed','createPageButtons','mainAreaTop','buttonAssistText1','Tab','meetVolumeShortcutConditions','isRepeated','setConfigValue','_buttonAssistWindow','ARRAYEVAL','_data','randomEncounters','cursorPageup','isRightInputMode','isClicked','buttonForbidden','Graphics_switchStretchMode','Scene_Title_update','Graphics_cancelFullScreen','keyNameAlign','onTouchCancel','processHandling','push','itemTextAlign','Press\x20a\x20gamepad\x20button\x20to\x20assign\x20this\x20control.','clear','createRebindWindow','updateButtonVisibility','_categoryWindow','textSizeEx','_switchStretchMode','getGamepadButtonID','ControllerButtons','commandSymbol','touchUI','create','isForbiddenKeycode','_scrollDuration','bgmVolume','checkGamepadButtonPress','inBattle','refreshCursor','parse','gamepadMapper','isSkill','Game_Party_hasEncounterNone','keyType','ButtonCommonEvents','upPan','extraColumns','buttonAssistText3','RebindWindow_BgType','buttonAssistBgType','prototype','Graphics_FPSCounter_switchMode','ARRAYSTR','cursorRight','constructor'];_0x525f=function(){return _0x4e7608;};return _0x525f();}function Scene_RebindKeyboard(){const _0x52c76b=_0x16899c;this[_0x52c76b(0x3ea)](...arguments);}Scene_RebindKeyboard[_0x16899c(0x2dd)]=Object[_0x16899c(0x2cb)](Scene_RebindBase[_0x16899c(0x2dd)]),Scene_RebindKeyboard[_0x16899c(0x2dd)][_0x16899c(0x2e1)]=Scene_RebindKeyboard,Scene_RebindKeyboard[_0x16899c(0x2dd)][_0x16899c(0x3ea)]=function(){const _0x273b90=_0x16899c;Scene_RebindBase['prototype'][_0x273b90(0x3ea)][_0x273b90(0x3d3)](this);},Scene_RebindKeyboard[_0x16899c(0x2dd)][_0x16899c(0x281)]=function(){return!![];},Scene_RebindKeyboard['prototype'][_0x16899c(0x381)]=function(){const _0x28ad7e=_0x16899c;Scene_RebindBase[_0x28ad7e(0x2dd)][_0x28ad7e(0x381)][_0x28ad7e(0x3d3)](this),this[_0x28ad7e(0x24c)]=this['_rebindWindow']['keyCode']();},Scene_RebindKeyboard[_0x16899c(0x2dd)]['inputKeyboardMessage']=function(){const _0x3ba85a=_0x16899c;return Window_KeyRebinds[_0x3ba85a(0x21a)][_0x3ba85a(0x35b)][_0x3ba85a(0x335)];},Scene_RebindKeyboard[_0x16899c(0x2dd)][_0x16899c(0x2cc)]=function(_0x352754){const _0xab57b6=_0x16899c,_0x5672e6=[];_0x5672e6[_0xab57b6(0x2be)](0xc0);for(let _0x5ce233=0x30;_0x5ce233<=0x39;_0x5ce233++)_0x5672e6[_0xab57b6(0x2be)](_0x5ce233);for(let _0x589020=0x41;_0x589020<=0x5a;_0x589020++)_0x5672e6['push'](_0x589020);for(let _0x25bee6=0xba;_0x25bee6<=0xc0;_0x25bee6++)_0x5672e6['push'](_0x25bee6);for(let _0xc6f862=0xdb;_0xc6f862<=0xde;_0xc6f862++)_0x5672e6[_0xab57b6(0x2be)](_0xc6f862);return!_0x5672e6[_0xab57b6(0x291)](_0x352754);},Scene_RebindKeyboard[_0x16899c(0x2dd)][_0x16899c(0x397)]=function(_0x4cb81d){const _0x243f3c=_0x16899c;Input['keyMapper'][this[_0x243f3c(0x24c)]]=Input[_0x243f3c(0x37b)][_0x4cb81d]||undefined;const _0x37ca8a=this[_0x243f3c(0x411)][_0x243f3c(0x2d6)]();Input[_0x243f3c(0x37b)][_0x4cb81d]=_0x37ca8a,Input[_0x243f3c(0x37b)][-0x1]=undefined,this[_0x243f3c(0x248)]();},Scene_RebindKeyboard[_0x16899c(0x2dd)]['reassignCoreEngineControls']=function(){const _0x238d5a=_0x16899c,_0x2f7fb2=VisuMZ['CoreEngine']['Settings'];_0x2f7fb2[_0x238d5a(0x220)][_0x238d5a(0x34e)]&&(Input[_0x238d5a(0x37b)][0x52]===undefined&&(Input[_0x238d5a(0x37b)][0x52]=_0x238d5a(0x3ba))),_0x2f7fb2[_0x238d5a(0x251)][_0x238d5a(0x399)]&&(Input['keyMapper'][0x23]=_0x238d5a(0x395),Input[_0x238d5a(0x37b)][0x24]='home');},Scene_RebindKeyboard[_0x16899c(0x2dd)][_0x16899c(0x215)]=function(_0x193d81){const _0x26261e=_0x16899c;Input[_0x26261e(0x37b)][Number(_0x193d81)]=undefined,SoundManager['playEquip'](),this[_0x26261e(0x411)][_0x26261e(0x38e)](),ConfigManager[_0x26261e(0x341)]();};function Scene_RebindGamepad(){this['initialize'](...arguments);}Scene_RebindGamepad[_0x16899c(0x2dd)]=Object['create'](Scene_RebindBase[_0x16899c(0x2dd)]),Scene_RebindGamepad[_0x16899c(0x2dd)]['constructor']=Scene_RebindGamepad,Scene_RebindGamepad[_0x16899c(0x2dd)][_0x16899c(0x3ea)]=function(){const _0xc45a65=_0x16899c;Scene_RebindBase[_0xc45a65(0x2dd)][_0xc45a65(0x3ea)][_0xc45a65(0x3d3)](this);},Scene_RebindGamepad[_0x16899c(0x2dd)][_0x16899c(0x1eb)]=function(){return!![];},Scene_RebindGamepad[_0x16899c(0x2dd)][_0x16899c(0x2da)]=function(){const _0x42c4ef=_0x16899c;return Window_KeyRebinds[_0x42c4ef(0x21a)][_0x42c4ef(0x343)][_0x42c4ef(0x38b)];},Scene_RebindGamepad[_0x16899c(0x2dd)][_0x16899c(0x381)]=function(){const _0xb35f6=_0x16899c;Input['isGamepadConnected']()?(Input[_0xb35f6(0x24b)]=!![],Input[_0xb35f6(0x39f)]=-0x1,Scene_RebindBase['prototype'][_0xb35f6(0x381)][_0xb35f6(0x3d3)](this),this[_0xb35f6(0x24c)]=this[_0xb35f6(0x411)]['keyCode']()):(this[_0xb35f6(0x411)][_0xb35f6(0x407)](),this[_0xb35f6(0x3f2)][_0xb35f6(0x26d)](Window_KeyRebinds[_0xb35f6(0x21a)][_0xb35f6(0x35b)][_0xb35f6(0x319)]));},Scene_RebindGamepad[_0x16899c(0x2dd)][_0x16899c(0x3fe)]=function(){const _0x4500a9=_0x16899c;return Window_KeyRebinds[_0x4500a9(0x21a)][_0x4500a9(0x35b)][_0x4500a9(0x3b8)];},Scene_RebindGamepad[_0x16899c(0x2dd)][_0x16899c(0x369)]=function(){const _0x5a8a7f=_0x16899c;Scene_RebindBase[_0x5a8a7f(0x2dd)][_0x5a8a7f(0x369)][_0x5a8a7f(0x3d3)](this),this[_0x5a8a7f(0x2cf)]();},Scene_RebindGamepad[_0x16899c(0x2dd)]['checkGamepadButtonPress']=function(){const _0x5bac71=_0x16899c;if(!this[_0x5bac71(0x2e7)][_0x5bac71(0x29c)]())return;if(Input[_0x5bac71(0x39f)]>=0x0){if([0xc,0xd,0xe,0xf][_0x5bac71(0x291)](Input[_0x5bac71(0x39f)]))return;this['processKeybind'](Input[_0x5bac71(0x39f)]);}},Scene_RebindGamepad[_0x16899c(0x2dd)][_0x16899c(0x3f1)]=function(){const _0x4712d1=_0x16899c;Input[_0x4712d1(0x24b)]=![],Input[_0x4712d1(0x39f)]=-0x1,Scene_RebindBase[_0x4712d1(0x2dd)]['cancelRebinding'][_0x4712d1(0x3d3)](this);},Scene_RebindGamepad[_0x16899c(0x2dd)][_0x16899c(0x397)]=function(_0x38d83b){const _0x6ae2cc=_0x16899c;Input[_0x6ae2cc(0x24b)]=![],Input[_0x6ae2cc(0x39f)]=-0x1,Input[_0x6ae2cc(0x2d3)][this[_0x6ae2cc(0x24c)]]=Input[_0x6ae2cc(0x2d3)][_0x38d83b]||undefined;const _0x5e701d=this[_0x6ae2cc(0x411)][_0x6ae2cc(0x2d6)]();Input['gamepadMapper'][_0x38d83b]=_0x5e701d,Input[_0x6ae2cc(0x2d3)][-0x1]=undefined;},Scene_RebindGamepad[_0x16899c(0x2dd)][_0x16899c(0x1f7)]=function(){const _0x2d99e2=_0x16899c;VisuMZ['OptionsCore']['Settings'][_0x2d99e2(0x2e9)][_0x2d99e2(0x278)]?VisuMZ['OptionsCore'][_0x2d99e2(0x277)][_0x2d99e2(0x2e9)]['gamepadReset']['call'](this):Input[_0x2d99e2(0x2d3)]={0x0:'ok',0x1:_0x2d99e2(0x284),0x2:_0x2d99e2(0x21e),0x3:_0x2d99e2(0x232),0x4:_0x2d99e2(0x2ed),0x5:'pagedown',0xc:'up',0xd:'down',0xe:'left',0xf:_0x2d99e2(0x351)},SoundManager[_0x2d99e2(0x340)](),this[_0x2d99e2(0x411)]['refresh'](),ConfigManager[_0x2d99e2(0x341)]();},uiDefault[_0x16899c(0x32d)]=Window_Selectable[_0x16899c(0x2dd)][_0x16899c(0x269)],Window_Selectable[_0x16899c(0x2dd)]['isHoverEnabled']=function(){const _0x5d89b0=_0x16899c;if(ConfigManager['uiHoverSelect']!==undefined)return ConfigManager[_0x5d89b0(0x292)];else{return uiDefault[_0x5d89b0(0x32d)][_0x5d89b0(0x3d3)](this);;}};function Window_OptionsCategory(){const _0x3d0174=_0x16899c;this[_0x3d0174(0x3ea)](...arguments);}Window_OptionsCategory['categoryList']=VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)][_0x16899c(0x223)],Window_OptionsCategory[_0x16899c(0x2dd)]=Object['create'](Window_HorzCommand[_0x16899c(0x2dd)]),Window_OptionsCategory['prototype'][_0x16899c(0x2e1)]=Window_OptionsCategory,Window_OptionsCategory['prototype']['initialize']=function(_0x2e5afd){const _0x32ffa9=_0x16899c;Window_HorzCommand[_0x32ffa9(0x2dd)][_0x32ffa9(0x3ea)][_0x32ffa9(0x3d3)](this,_0x2e5afd),this[_0x32ffa9(0x209)](_0x2e5afd);},Window_OptionsCategory[_0x16899c(0x2dd)][_0x16899c(0x303)]=function(){const _0x366898=_0x16899c;return Imported[_0x366898(0x377)]&&Window_HorzCommand[_0x366898(0x2dd)][_0x366898(0x303)][_0x366898(0x3d3)](this);},Window_OptionsCategory[_0x16899c(0x2dd)][_0x16899c(0x209)]=function(_0x51d2bb){const _0x177f2d=_0x16899c,_0x2f9c40=new Rectangle(0x0,0x0,_0x51d2bb['width'],_0x51d2bb[_0x177f2d(0x3f6)]);this[_0x177f2d(0x3fd)]=new Window_Base(_0x2f9c40),this[_0x177f2d(0x3fd)][_0x177f2d(0x3b1)]=0x0,this[_0x177f2d(0x3c4)](this[_0x177f2d(0x3fd)]),this[_0x177f2d(0x20b)]();},Window_OptionsCategory[_0x16899c(0x2dd)][_0x16899c(0x3b4)]=function(){const _0x421221=_0x16899c;Window_HorzCommand[_0x421221(0x2dd)][_0x421221(0x3b4)][_0x421221(0x3d3)](this);if(this[_0x421221(0x3fd)])this[_0x421221(0x20b)]();},Window_OptionsCategory[_0x16899c(0x2dd)][_0x16899c(0x20b)]=function(){const _0x2915e5=_0x16899c,_0xc08a1a=this['_commandNameWindow'];_0xc08a1a[_0x2915e5(0x389)][_0x2915e5(0x2c1)]();const _0x3a149f=this['commandStyleCheck'](this[_0x2915e5(0x3d6)]());if(_0x3a149f===_0x2915e5(0x1f3)){const _0x197e66=this[_0x2915e5(0x347)](this['index']());let _0x83fe88=this[_0x2915e5(0x37e)](this['index']());_0x83fe88=_0x83fe88[_0x2915e5(0x3fa)](/\\I\[(\d+)\]/gi,''),_0xc08a1a[_0x2915e5(0x310)](),this['commandNameWindowDrawBackground'](_0x83fe88,_0x197e66),this[_0x2915e5(0x36c)](_0x83fe88,_0x197e66),this[_0x2915e5(0x27d)](_0x83fe88,_0x197e66);}},Window_OptionsCategory[_0x16899c(0x2dd)]['commandNameWindowDrawBackground']=function(_0x4ef66c,_0x34d27b){},Window_OptionsCategory['prototype']['processCursorHomeEndTrigger']=function(){},Window_OptionsCategory[_0x16899c(0x2dd)][_0x16899c(0x36c)]=function(_0x571bd4,_0x21dcda){const _0x3c110d=_0x16899c,_0x39a67f=this[_0x3c110d(0x3fd)];_0x39a67f[_0x3c110d(0x314)](_0x571bd4,0x0,_0x21dcda['y'],_0x39a67f['innerWidth'],'center');},Window_OptionsCategory[_0x16899c(0x2dd)][_0x16899c(0x27d)]=function(_0x353f8c,_0x1aebd7){const _0x237244=_0x16899c,_0x4a22ca=this['_commandNameWindow'],_0x1ac377=$gameSystem[_0x237244(0x280)](),_0x3c9bf3=_0x1aebd7['x']+Math['floor'](_0x1aebd7['width']/0x2)+_0x1ac377;_0x4a22ca['x']=_0x4a22ca[_0x237244(0x243)]/-0x2+_0x3c9bf3,_0x4a22ca['y']=Math[_0x237244(0x3b3)](_0x1aebd7[_0x237244(0x3f6)]/0x2);},Window_OptionsCategory[_0x16899c(0x2dd)][_0x16899c(0x25c)]=function(){const _0x22f977=_0x16899c;return this[_0x22f977(0x35f)]?this[_0x22f977(0x35f)]['length']:0x1;},Window_OptionsCategory[_0x16899c(0x2dd)]['setListWindow']=function(_0x2492ad){const _0x17fb6d=_0x16899c;this[_0x17fb6d(0x380)]=_0x2492ad,this[_0x17fb6d(0x38e)]();},Window_OptionsCategory[_0x16899c(0x2dd)][_0x16899c(0x369)]=function(){const _0x5ea0e3=_0x16899c;Window_HorzCommand[_0x5ea0e3(0x2dd)][_0x5ea0e3(0x369)][_0x5ea0e3(0x3d3)](this),this[_0x5ea0e3(0x380)]&&this[_0x5ea0e3(0x380)]['setCategory'](this[_0x5ea0e3(0x316)]());},Window_OptionsCategory[_0x16899c(0x2dd)][_0x16899c(0x1ee)]=function(){const _0x1bfdd4=_0x16899c;if(this['isCursorMovable']()){const _0x8dcfc2=this['index']();Input['isRepeated']('pagedown')&&this[_0x1bfdd4(0x2e0)](Input[_0x1bfdd4(0x294)](_0x1bfdd4(0x2a4))),Input[_0x1bfdd4(0x2ae)](_0x1bfdd4(0x2ed))&&this[_0x1bfdd4(0x276)](Input[_0x1bfdd4(0x294)](_0x1bfdd4(0x2ed))),this[_0x1bfdd4(0x3d6)]()!==_0x8dcfc2&&this['playCursorSound']();}},Window_OptionsCategory['prototype'][_0x16899c(0x2bd)]=function(){const _0xfd1daa=_0x16899c;if(this[_0xfd1daa(0x303)]())return;Window_HorzCommand[_0xfd1daa(0x2dd)][_0xfd1daa(0x2bd)][_0xfd1daa(0x3d3)](this);},Window_OptionsCategory[_0x16899c(0x2dd)][_0x16899c(0x269)]=function(){const _0x3046ba=_0x16899c;return this[_0x3046ba(0x303)]()?![]:Window_HorzCommand[_0x3046ba(0x2dd)][_0x3046ba(0x269)][_0x3046ba(0x3d3)](this);},Window_OptionsCategory['prototype']['processTouchModernControls']=function(){const _0x4c0be6=_0x16899c;if(this['isOpenAndActive']()){TouchInput['isTriggered']()&&this['onTouchSelect'](!![]);if(TouchInput[_0x4c0be6(0x2b6)]())this[_0x4c0be6(0x3fb)]();else TouchInput[_0x4c0be6(0x31f)]()&&this[_0x4c0be6(0x2bc)]();}},Window_OptionsCategory[_0x16899c(0x2dd)][_0x16899c(0x3da)]=function(_0x1033ca){const _0xdad4a5=_0x16899c;this[_0xdad4a5(0x303)]()?this[_0xdad4a5(0x29d)](!![]):Window_HorzCommand['prototype'][_0xdad4a5(0x3da)]['call'](this,_0x1033ca);},Window_OptionsCategory[_0x16899c(0x2dd)][_0x16899c(0x29d)]=function(_0x59585a){const _0x5cdac1=_0x16899c;this[_0x5cdac1(0x3e4)]=![];if(this[_0x5cdac1(0x382)]()){const _0x26c12a=this['index'](),_0x10a93f=this['hitIndex']();_0x10a93f>=0x0&&_0x10a93f!==this[_0x5cdac1(0x3d6)]()&&this[_0x5cdac1(0x1ed)](_0x10a93f),_0x59585a&&this[_0x5cdac1(0x3d6)]()!==_0x26c12a&&this[_0x5cdac1(0x322)]();}},Window_OptionsCategory['prototype'][_0x16899c(0x324)]=function(){const _0x2c5dc1=_0x16899c;for(const _0xb597dd of Window_OptionsCategory[_0x2c5dc1(0x3c0)]){if(!_0xb597dd[_0x2c5dc1(0x37d)][_0x2c5dc1(0x3d3)](this))continue;const _0x466844=this[_0x2c5dc1(0x2fe)](),_0x6302d5=_0xb597dd['Name'],_0x523d96=_0xb597dd[_0x2c5dc1(0x3a8)],_0x4301c9=_0x466844===_0x2c5dc1(0x39a)?_0x6302d5:_0x2c5dc1(0x374)[_0x2c5dc1(0x3f5)](_0x523d96,_0x6302d5),_0x5ae529=_0xb597dd[_0x2c5dc1(0x27f)];this[_0x2c5dc1(0x3e7)](_0x4301c9,_0x2c5dc1(0x348),!![],_0x5ae529);}},Window_OptionsCategory['prototype'][_0x16899c(0x2bf)]=function(){const _0x51269b=_0x16899c;return VisuMZ['OptionsCore'][_0x51269b(0x277)][_0x51269b(0x33b)][_0x51269b(0x3e8)];},Window_OptionsCategory['prototype'][_0x16899c(0x293)]=function(_0x3d4815){const _0x567e64=_0x16899c,_0x2e062e=this['commandStyleCheck'](_0x3d4815);if(_0x2e062e===_0x567e64(0x33a))this[_0x567e64(0x3df)](_0x3d4815);else _0x2e062e==='icon'?this[_0x567e64(0x261)](_0x3d4815):Window_HorzCommand[_0x567e64(0x2dd)]['drawItem']['call'](this,_0x3d4815);},Window_OptionsCategory[_0x16899c(0x2dd)][_0x16899c(0x2fe)]=function(){const _0x16bd4e=_0x16899c;return VisuMZ[_0x16bd4e(0x3c1)][_0x16bd4e(0x277)][_0x16bd4e(0x33b)][_0x16bd4e(0x3d1)];},Window_OptionsCategory['prototype']['commandStyleCheck']=function(_0x3b5c70){const _0x1c4982=_0x16899c;if(_0x3b5c70<0x0)return _0x1c4982(0x39a);const _0x233c77=this[_0x1c4982(0x2fe)]();if(_0x233c77!==_0x1c4982(0x299))return _0x233c77;else{if(this['maxItems']()>0x0){const _0x3bc222=this[_0x1c4982(0x37e)](_0x3b5c70);if(_0x3bc222[_0x1c4982(0x30f)](/\\I\[(\d+)\]/i)){const _0x7fb945=this[_0x1c4982(0x347)](_0x3b5c70),_0x182399=this['textSizeEx'](_0x3bc222)[_0x1c4982(0x243)];return _0x182399<=_0x7fb945[_0x1c4982(0x243)]?'iconText':_0x1c4982(0x1f3);}}}return _0x1c4982(0x39a);},Window_OptionsCategory[_0x16899c(0x2dd)][_0x16899c(0x3df)]=function(_0x521b10){const _0x1377a9=_0x16899c,_0x5d482c=this[_0x1377a9(0x347)](_0x521b10),_0x1f2b2e=this[_0x1377a9(0x37e)](_0x521b10),_0x51dee5=this[_0x1377a9(0x2c5)](_0x1f2b2e)[_0x1377a9(0x243)];this[_0x1377a9(0x3fc)](this[_0x1377a9(0x275)](_0x521b10));const _0x536b6c=this[_0x1377a9(0x2bf)]();if(_0x536b6c==='right')this[_0x1377a9(0x361)](_0x1f2b2e,_0x5d482c['x']+_0x5d482c[_0x1377a9(0x243)]-_0x51dee5,_0x5d482c['y'],_0x51dee5);else{if(_0x536b6c===_0x1377a9(0x3a7)){const _0x20e174=_0x5d482c['x']+Math[_0x1377a9(0x3b3)]((_0x5d482c['width']-_0x51dee5)/0x2);this[_0x1377a9(0x361)](_0x1f2b2e,_0x20e174,_0x5d482c['y'],_0x51dee5);}else this['drawTextEx'](_0x1f2b2e,_0x5d482c['x'],_0x5d482c['y'],_0x51dee5);}},Window_OptionsCategory['prototype'][_0x16899c(0x261)]=function(_0x162742){const _0x1c60d8=_0x16899c;this[_0x1c60d8(0x37e)](_0x162742)[_0x1c60d8(0x30f)](/\\I\[(\d+)\]/i);const _0x20f2c9=Number(RegExp['$1'])||0x0,_0x583ac0=this['itemLineRect'](_0x162742),_0xa1b41e=_0x583ac0['x']+Math[_0x1c60d8(0x3b3)]((_0x583ac0[_0x1c60d8(0x243)]-ImageManager['iconWidth'])/0x2),_0x4479ce=_0x583ac0['y']+(_0x583ac0[_0x1c60d8(0x3f6)]-ImageManager[_0x1c60d8(0x2f3)])/0x2;this['drawIcon'](_0x20f2c9,_0xa1b41e,_0x4479ce);},VisuMZ[_0x16899c(0x3c1)]['Window_Options_initialize']=Window_Options[_0x16899c(0x2dd)][_0x16899c(0x3ea)],Window_Options[_0x16899c(0x2dd)][_0x16899c(0x3ea)]=function(_0x2d3eef){const _0x47f424=_0x16899c;this[_0x47f424(0x28e)]=null,this['_data']=null,VisuMZ[_0x47f424(0x3c1)][_0x47f424(0x3ae)][_0x47f424(0x3d3)](this,_0x2d3eef);},Window_Options[_0x16899c(0x2dd)][_0x16899c(0x2ea)]=function(_0x47e000){const _0x242928=_0x16899c;if(!_0x47e000)return;if(_0x47e000['name']===this[_0x242928(0x28e)])return;this[_0x242928(0x28e)]=_0x47e000[_0x242928(0x3d4)],this[_0x242928(0x2b2)]=_0x47e000[_0x242928(0x321)],this[_0x242928(0x23f)](0x0,0x0),this[_0x242928(0x38e)]();if(this[_0x242928(0x303)]())this['smoothSelect'](0x0);},Window_Options[_0x16899c(0x2dd)]['getConfigValue']=function(_0x5a92a8){return ConfigManager[_0x5a92a8];},Window_Options[_0x16899c(0x2dd)][_0x16899c(0x2af)]=function(_0x48413a,_0x5b1846){ConfigManager[_0x48413a]=_0x5b1846;},Window_Options[_0x16899c(0x2dd)][_0x16899c(0x3bd)]=function(){const _0x29f3cd=_0x16899c;$gameTemp['_returnOptionsCore']={'category':SceneManager[_0x29f3cd(0x365)][_0x29f3cd(0x2c4)]['index'](),'index':this['index'](),'scrollX':this['_scrollX'],'scrollY':this[_0x29f3cd(0x219)]};},Window_Options[_0x16899c(0x2dd)][_0x16899c(0x282)]=function(){const _0x4e03ce=_0x16899c;return Scene_Options[_0x4e03ce(0x349)];},Window_Options[_0x16899c(0x2dd)]['isUseModernControls']=function(){const _0x3d8c5b=_0x16899c;return Imported[_0x3d8c5b(0x377)]&&Window_HorzCommand[_0x3d8c5b(0x2dd)][_0x3d8c5b(0x303)][_0x3d8c5b(0x3d3)](this);},Window_Options[_0x16899c(0x2dd)][_0x16899c(0x1ee)]=function(){const _0x159123=_0x16899c;if(this[_0x159123(0x382)]()){const _0x4333ec=this[_0x159123(0x3d6)]();Input[_0x159123(0x2ae)](_0x159123(0x241))&&(Input[_0x159123(0x2a8)](_0x159123(0x21e))?this[_0x159123(0x358)]():this[_0x159123(0x273)](Input[_0x159123(0x294)]('down'))),Input['isRepeated']('up')&&(Input['isPressed'](_0x159123(0x21e))?this[_0x159123(0x2b4)]():this[_0x159123(0x1fe)](Input[_0x159123(0x294)]('up'))),Input['isRepeated'](_0x159123(0x351))&&this[_0x159123(0x2e0)](Input[_0x159123(0x294)](_0x159123(0x351))),Input[_0x159123(0x2ae)](_0x159123(0x2fb))&&this[_0x159123(0x276)](Input[_0x159123(0x294)](_0x159123(0x2fb))),this['index']()!==_0x4333ec&&this['playCursorSound']();}},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x304)]=Window_Options['prototype'][_0x16899c(0x255)],Window_Options[_0x16899c(0x2dd)]['processOk']=function(){const _0x3dcd8a=_0x16899c,_0x4eb31c=this[_0x3dcd8a(0x3d6)](),_0x500a0a=this[_0x3dcd8a(0x2c9)](_0x4eb31c);if(!this[_0x3dcd8a(0x275)](_0x4eb31c)){this[_0x3dcd8a(0x235)]();return;}try{this[_0x3dcd8a(0x3ab)][_0x4eb31c][_0x3dcd8a(0x259)][_0x3dcd8a(0x3d3)](this,_0x500a0a,_0x4eb31c);}catch(_0x4de3ff){VisuMZ[_0x3dcd8a(0x3c1)]['Window_Options_processOk'][_0x3dcd8a(0x3d3)](this);}},VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x3eb)]=Window_Options[_0x16899c(0x2dd)][_0x16899c(0x2e0)],Window_Options[_0x16899c(0x2dd)][_0x16899c(0x2e0)]=function(){const _0x5bb821=_0x16899c,_0x5ac6ef=this['index'](),_0x1e95e6=this[_0x5bb821(0x2c9)](_0x5ac6ef);if(!this[_0x5bb821(0x275)](_0x5ac6ef)){this[_0x5bb821(0x235)]();return;}try{this['_dataFunc'][_0x5ac6ef][_0x5bb821(0x3dd)][_0x5bb821(0x3d3)](this,_0x1e95e6,_0x5ac6ef);}catch(_0x4f7b9f){VisuMZ[_0x5bb821(0x3c1)][_0x5bb821(0x3eb)][_0x5bb821(0x3d3)](this);}},VisuMZ[_0x16899c(0x3c1)]['Window_Options_cursorLeft']=Window_Options['prototype']['cursorLeft'],Window_Options[_0x16899c(0x2dd)][_0x16899c(0x276)]=function(){const _0x4e9ef2=_0x16899c,_0xc0c8dc=this[_0x4e9ef2(0x3d6)](),_0x52e774=this[_0x4e9ef2(0x2c9)](_0xc0c8dc);if(!this[_0x4e9ef2(0x275)](_0xc0c8dc)){this[_0x4e9ef2(0x235)]();return;}try{this[_0x4e9ef2(0x3ab)][_0xc0c8dc][_0x4e9ef2(0x21b)][_0x4e9ef2(0x3d3)](this,_0x52e774,_0xc0c8dc);}catch(_0x53ccc3){VisuMZ[_0x4e9ef2(0x3c1)][_0x4e9ef2(0x386)][_0x4e9ef2(0x3d3)](this);}},Window_Options[_0x16899c(0x2dd)][_0x16899c(0x324)]=function(){const _0x8deb1=_0x16899c;if(!this[_0x8deb1(0x2b2)])return;this[_0x8deb1(0x3ab)]=[];for(const _0x198387 of this[_0x8deb1(0x2b2)]){if(!_0x198387['ShowJS']['call'](this))continue;let _0x2e042b=_0x198387[_0x8deb1(0x342)];if(['',_0x8deb1(0x21c)][_0x8deb1(0x291)](_0x2e042b))_0x2e042b=_0x198387['TextJS'][_0x8deb1(0x3d3)](this);const _0x560a3a=_0x198387[_0x8deb1(0x3a8)];_0x560a3a>0x0&&(_0x2e042b=_0x8deb1(0x374)[_0x8deb1(0x3f5)](_0x560a3a,_0x2e042b));const _0x5f09d4=_0x198387['Symbol'],_0x52d837=_0x198387[_0x8deb1(0x268)][_0x8deb1(0x3d3)](this),_0x34af12=_0x198387['ExtJS']['call'](this);this[_0x8deb1(0x3e7)](_0x2e042b,_0x5f09d4,_0x52d837,_0x34af12),this[_0x8deb1(0x3ab)][_0x8deb1(0x2be)](_0x198387);}},VisuMZ[_0x16899c(0x3c1)]['Window_Options_drawItem']=Window_Options[_0x16899c(0x2dd)][_0x16899c(0x293)],Window_Options['prototype'][_0x16899c(0x293)]=function(_0xcc6f5){const _0x4277b=_0x16899c;this[_0x4277b(0x310)](),this[_0x4277b(0x3fc)](this['isCommandEnabled'](_0xcc6f5));const _0x49b3e6=this[_0x4277b(0x35f)][_0xcc6f5][_0x4277b(0x3d0)];this['_currentDrawingIndex']=_0xcc6f5;try{this[_0x4277b(0x3ab)][_0xcc6f5]['DrawJS'][_0x4277b(0x3d3)](this,_0x49b3e6,_0xcc6f5);}catch(_0x1e1065){VisuMZ[_0x4277b(0x3c1)]['Window_Options_drawItem'][_0x4277b(0x3d3)](this,_0xcc6f5);}this['_currentDrawingIndex']=undefined;},Window_Options[_0x16899c(0x2dd)][_0x16899c(0x2c3)]=function(){const _0x331234=_0x16899c;SceneManager['_scene'][_0x331234(0x2c3)]();},Window_Options['prototype']['updateButtonPositions']=function(){const _0x4c5770=_0x16899c;SceneManager[_0x4c5770(0x365)][_0x4c5770(0x339)]();},Window_Options[_0x16899c(0x2dd)][_0x16899c(0x3e9)]=function(){const _0x26bf12=_0x16899c;SceneManager['_scene'][_0x26bf12(0x379)]();},Window_Options[_0x16899c(0x2dd)][_0x16899c(0x301)]=function(){const _0x4f58bf=_0x16899c;if(SceneManager['_scene'][_0x4f58bf(0x2e1)]!==Scene_Options)return;SceneManager[_0x4f58bf(0x365)][_0x4f58bf(0x301)]();},Window_Options['prototype'][_0x16899c(0x314)]=function(_0x3a13cb,_0x2d85a8,_0x4f24f0,_0x5798fc,_0x46dd3f){const _0x292e62=_0x16899c,_0x42ef8a=this[_0x292e62(0x389)][_0x292e62(0x40a)];this[_0x292e62(0x3be)]>=0x0&&(!this['isCommandEnabled'](this['_currentDrawingIndex'])&&this[_0x292e62(0x3fc)](![])),Window_Command[_0x292e62(0x2dd)]['drawText'][_0x292e62(0x3d3)](this,_0x3a13cb,_0x2d85a8,_0x4f24f0,_0x5798fc,_0x46dd3f),this[_0x292e62(0x389)][_0x292e62(0x40a)]=_0x42ef8a;},Window_Options[_0x16899c(0x2dd)]['drawTextEx']=function(_0x19a731,_0xb675fb,_0x32d41f,_0x5d5f61){const _0xb97d11=_0x16899c;this[_0xb97d11(0x310)]();const _0x2b68e7=this[_0xb97d11(0x389)][_0xb97d11(0x40a)];this['_currentDrawingIndex']>=0x0&&(!this[_0xb97d11(0x275)](this[_0xb97d11(0x3be)])&&this[_0xb97d11(0x3fc)](![]));const _0x47467f=this[_0xb97d11(0x2f1)](_0x19a731,_0xb675fb,_0x32d41f,_0x5d5f61);this[_0xb97d11(0x355)](_0x47467f);const _0x125dfb=_0x47467f[_0xb97d11(0x2fc)];return this[_0xb97d11(0x389)]['paintOpacity']=_0x2b68e7,_0x125dfb;};function Window_RebindHelp(){this['initialize'](...arguments);}Window_RebindHelp[_0x16899c(0x2dd)]=Object[_0x16899c(0x2cb)](Window_Help[_0x16899c(0x2dd)]),Window_RebindHelp['prototype'][_0x16899c(0x2e1)]=Window_RebindHelp,Window_RebindHelp['prototype'][_0x16899c(0x3ea)]=function(_0x19bc43){const _0x2912b5=_0x16899c;Window_Help[_0x2912b5(0x2dd)][_0x2912b5(0x3ea)][_0x2912b5(0x3d3)](this,_0x19bc43);},Window_RebindHelp['prototype']['updateBackOpacity']=function(){this['backOpacity']=0xff;},Window_RebindHelp[_0x16899c(0x2dd)]['refresh']=function(){const _0x3a64be=_0x16899c;this[_0x3a64be(0x389)][_0x3a64be(0x2c1)]();const _0x1998af=this['textSizeEx'](this['_text']),_0x4e1bff=Math[_0x3a64be(0x297)]((this[_0x3a64be(0x33c)]-_0x1998af[_0x3a64be(0x243)])/0x2),_0x2d162e=Math['round']((this[_0x3a64be(0x3c7)]-_0x1998af[_0x3a64be(0x3f6)])/0x2);this[_0x3a64be(0x361)](this[_0x3a64be(0x2f8)],_0x4e1bff,_0x2d162e);};function Window_KeyRebinds(){const _0x1b0537=_0x16899c;this[_0x1b0537(0x3ea)](...arguments);}Window_KeyRebinds[_0x16899c(0x2dd)]=Object[_0x16899c(0x2cb)](Window_Command[_0x16899c(0x2dd)]),Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x2e1)]=Window_KeyRebinds,Window_KeyRebinds[_0x16899c(0x21a)]={'bgType':VisuMZ[_0x16899c(0x3c1)]['Settings'][_0x16899c(0x2e9)][_0x16899c(0x2db)]??0x0,'keyOrder':VisuMZ['OptionsCore']['Settings']['Rebind'][_0x16899c(0x300)]??['up',_0x16899c(0x2fb),_0x16899c(0x241),_0x16899c(0x351),'ok',_0x16899c(0x33e),'shift',_0x16899c(0x385),'pageup',_0x16899c(0x2a4)],'gamepadOrder':VisuMZ['OptionsCore'][_0x16899c(0x277)][_0x16899c(0x2e9)][_0x16899c(0x312)]??['up','left',_0x16899c(0x241),_0x16899c(0x351),'ok',_0x16899c(0x284),_0x16899c(0x232),'shift',_0x16899c(0x2ed),'pagedown'],'keyNameAlign':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)][_0x16899c(0x2e9)]['keyNameAlign']??_0x16899c(0x3a7),'rebindAlign':VisuMZ['OptionsCore'][_0x16899c(0x277)][_0x16899c(0x2e9)]['rebindAlign']??'center','buttonAssist':{'remove':VisuMZ[_0x16899c(0x3c1)]['Settings'][_0x16899c(0x2e9)][_0x16899c(0x3e5)]??_0x16899c(0x27a),'reset':VisuMZ['OptionsCore'][_0x16899c(0x277)][_0x16899c(0x2e9)][_0x16899c(0x22f)]??_0x16899c(0x27e),'confirm':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)]['Rebind']['confirmAssist']??_0x16899c(0x2e9),'cancel':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)][_0x16899c(0x2e9)][_0x16899c(0x287)]??'Exit'},'helpText':{'selectKeyboard':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)][_0x16899c(0x2e9)][_0x16899c(0x39e)]??_0x16899c(0x3a3),'selectGamepad':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)]['Rebind'][_0x16899c(0x233)]??_0x16899c(0x35c),'pressKeyboard':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)][_0x16899c(0x2e9)][_0x16899c(0x335)]??'Press\x20a\x20keyboard\x20button\x20to\x20assign\x20this\x20control.','pressGamepad':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)]['Rebind'][_0x16899c(0x3b8)]??_0x16899c(0x2c0),'pressForbidden':VisuMZ[_0x16899c(0x3c1)][_0x16899c(0x277)]['Rebind'][_0x16899c(0x1f4)]??_0x16899c(0x1f0),'buttonForbidden':VisuMZ[_0x16899c(0x3c1)]['Settings'][_0x16899c(0x2e9)][_0x16899c(0x2b7)]??'This\x20button\x20cannot\x20be\x20reassigned.','noGamepadFound':VisuMZ[_0x16899c(0x3c1)]['Settings'][_0x16899c(0x2e9)][_0x16899c(0x319)]??_0x16899c(0x266)}},Window_KeyRebinds['prototype']['initialize']=function(_0x54a41f){const _0xe59f9b=_0x16899c;this['setupType'](),Window_Command['prototype']['initialize'][_0xe59f9b(0x3d3)](this,_0x54a41f),this[_0xe59f9b(0x1ed)](this[_0xe59f9b(0x281)]()?0x2:0x1);},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x357)]=function(){const _0x588b16=_0x16899c,_0x5225f7=SceneManager[_0x588b16(0x365)][_0x588b16(0x2e1)][_0x588b16(0x3d4)];if(_0x5225f7===_0x588b16(0x229))this[_0x588b16(0x27c)]=_0x588b16(0x28f);else _0x5225f7===_0x588b16(0x2e6)?this[_0x588b16(0x27c)]=_0x588b16(0x2f6):this[_0x588b16(0x27c)]='none';},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x281)]=function(){const _0x331254=_0x16899c;return this[_0x331254(0x27c)]===_0x331254(0x28f);},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x1eb)]=function(){const _0x1297ff=_0x16899c;return this['_type']===_0x1297ff(0x2f6);},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x25c)]=function(){const _0x53780d=_0x16899c;return 0x1+this[_0x53780d(0x2d9)]();},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x2d9)]=function(){const _0x55f1f3=_0x16899c;if(this['isForKeyboard']())return 0x2;else{if(this[_0x55f1f3(0x1eb)]())return 0x1;}return 0x0;},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x1f2)]=function(){const _0xa10a30=_0x16899c;if(this[_0xa10a30(0x281)]()){const _0x32a92b=this[_0xa10a30(0x3d6)](),_0x5df3fc=Number(this[_0xa10a30(0x37e)](_0x32a92b)),_0x554840=String(this['_list'][_0x32a92b]['ext']||''),_0xf18d61=Input['getKeyboardMappingByKeyType'](_0x554840)||[];return Number(_0xf18d61[_0x5df3fc]??-0x1);}else{if(this[_0xa10a30(0x1eb)]()){const _0x14f395=this[_0xa10a30(0x3d6)](),_0x3f4901=String(this[_0xa10a30(0x35f)][_0x14f395][_0xa10a30(0x321)]||'');return Input['getGamepadButtonID'](_0x3f4901)[0x0];}}},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x2d6)]=function(){const _0x32ec63=_0x16899c,_0x5a6a69=this[_0x32ec63(0x3d6)]();return String(this['_list'][_0x5a6a69][_0x32ec63(0x321)]||'');},Window_KeyRebinds['prototype'][_0x16899c(0x1ed)]=function(_0x1121c7){const _0x56b892=_0x16899c;if(Input[_0x56b892(0x294)]('home'))_0x1121c7=this[_0x56b892(0x281)]()?0x2:0x1;if(this[_0x56b892(0x281)]()){if(_0x1121c7%this[_0x56b892(0x25c)]()===0x1)return;}if(_0x1121c7%this[_0x56b892(0x25c)]()===0x0)return;Window_Command['prototype'][_0x56b892(0x1ed)][_0x56b892(0x3d3)](this,_0x1121c7);},Window_KeyRebinds['prototype'][_0x16899c(0x201)]=function(){const _0x5ae5c5=_0x16899c;this[_0x5ae5c5(0x1eb)]()&&!Input[_0x5ae5c5(0x3f4)]()?this['playBuzzerSound']():Window_Command[_0x5ae5c5(0x2dd)][_0x5ae5c5(0x201)][_0x5ae5c5(0x3d3)](this);},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x235)]=function(){const _0x3a2cde=_0x16899c;Window_Command[_0x3a2cde(0x2dd)][_0x3a2cde(0x235)]['call'](this),this[_0x3a2cde(0x1eb)]()&&this['_helpWindow']&&this[_0x3a2cde(0x3f2)][_0x3a2cde(0x26d)](Window_KeyRebinds[_0x3a2cde(0x21a)][_0x3a2cde(0x35b)][_0x3a2cde(0x2b7)]);},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x324)]=function(){const _0x45c829=_0x16899c,_0x5d7381=Window_KeyRebinds[_0x45c829(0x21a)],_0x95453=this[_0x45c829(0x281)]()?_0x5d7381[_0x45c829(0x300)]:_0x5d7381[_0x45c829(0x312)];for(const _0x33b7f3 of _0x95453){this[_0x45c829(0x31e)](_0x33b7f3);}},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x31e)]=function(_0x1357b7){const _0x8868ce=_0x16899c,_0x57d0a5=this[_0x8868ce(0x2d9)]();if(_0x57d0a5<=0x0)return;this[_0x8868ce(0x3e7)](_0x1357b7,_0x8868ce(0x3e3),![],_0x1357b7);for(let _0x2e85e3=0x0;_0x2e85e3<_0x57d0a5;_0x2e85e3++){const _0x1a89d5=this[_0x8868ce(0x270)](_0x1357b7,_0x2e85e3);this['addCommand'](String(_0x2e85e3),_0x8868ce(0x352),_0x1a89d5,_0x1357b7);}},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x270)]=function(_0xcaf685,_0x2cea12){const _0x18fb9b=_0x16899c;if(this[_0x18fb9b(0x281)]()){if(_0x2cea12===0x0)return![];}else{if(this['isForGamepad']()){if(['up',_0x18fb9b(0x2fb),_0x18fb9b(0x241),_0x18fb9b(0x351)]['includes'](_0xcaf685))return![];}}return!![];},Window_KeyRebinds[_0x16899c(0x2dd)]['drawItemBackground']=function(_0x7aca91){const _0x3b2b2d=_0x16899c;if(_0x7aca91%this[_0x3b2b2d(0x25c)]()===0x0)return;const _0x22ab9f=this[_0x3b2b2d(0x267)](_0x7aca91);this[_0x3b2b2d(0x330)](_0x22ab9f);},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x293)]=function(_0x3379c9){const _0x4e49e4=_0x16899c,_0x5133f0=this[_0x4e49e4(0x2c9)](_0x3379c9);if(_0x5133f0==='keyName')this[_0x4e49e4(0x3cc)](_0x3379c9);else _0x5133f0===_0x4e49e4(0x352)&&this[_0x4e49e4(0x200)](_0x3379c9);},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x3cc)]=function(_0x32ba8f){const _0x3bdd47=_0x16899c,_0x169676=Window_KeyRebinds[_0x3bdd47(0x21a)],_0x35871e=this['itemLineRect'](_0x32ba8f),_0x46d198=TextManager[_0x3bdd47(0x383)][this[_0x3bdd47(0x35f)][_0x32ba8f][_0x3bdd47(0x321)]]||'',_0x17e4d4=this[_0x3bdd47(0x2c5)](_0x46d198)[_0x3bdd47(0x243)],_0x2e3f24=_0x169676['keyNameAlign']||'center';this[_0x3bdd47(0x310)](),this[_0x3bdd47(0x3fc)](!![]);if(_0x2e3f24===_0x3bdd47(0x351))this[_0x3bdd47(0x361)](_0x46d198,_0x35871e['x']+_0x35871e[_0x3bdd47(0x243)]-_0x17e4d4,_0x35871e['y'],_0x17e4d4);else{if(_0x2e3f24===_0x3bdd47(0x3a7)){const _0x5e7a28=_0x35871e['x']+Math[_0x3bdd47(0x3b3)]((_0x35871e[_0x3bdd47(0x243)]-_0x17e4d4)/0x2);this[_0x3bdd47(0x361)](_0x46d198,_0x5e7a28,_0x35871e['y'],_0x17e4d4);}else this[_0x3bdd47(0x361)](_0x46d198,_0x35871e['x'],_0x35871e['y'],_0x17e4d4);}},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x200)]=function(_0x5d8059){const _0x379f40=_0x16899c,_0x4a180e=Window_KeyRebinds[_0x379f40(0x21a)],_0x51f0be=this[_0x379f40(0x347)](_0x5d8059),_0x10a6f4=Number(this[_0x379f40(0x37e)](_0x5d8059)),_0x563b28=String(this[_0x379f40(0x35f)][_0x5d8059][_0x379f40(0x321)]||'');$gameTemp[_0x379f40(0x32f)]=this['isForGamepad']();const _0x140b34=this['getKeyName'](_0x10a6f4,_0x563b28);$gameTemp[_0x379f40(0x32f)]=undefined;const _0x158164=this[_0x379f40(0x2c5)](_0x140b34)['width'],_0xf7280f=_0x4a180e[_0x379f40(0x2bb)]||_0x379f40(0x3a7);this[_0x379f40(0x310)](),this[_0x379f40(0x3fc)](this[_0x379f40(0x275)](_0x5d8059));if(_0xf7280f===_0x379f40(0x351))this[_0x379f40(0x361)](_0x140b34,_0x51f0be['x']+_0x51f0be[_0x379f40(0x243)]-_0x158164,_0x51f0be['y'],_0x158164);else{if(_0xf7280f===_0x379f40(0x3a7)){const _0x3ebde7=_0x51f0be['x']+Math[_0x379f40(0x3b3)]((_0x51f0be[_0x379f40(0x243)]-_0x158164)/0x2);this['drawTextEx'](_0x140b34,_0x3ebde7,_0x51f0be['y'],_0x158164);}else this[_0x379f40(0x361)](_0x140b34,_0x51f0be['x'],_0x51f0be['y'],_0x158164);}},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x396)]=function(_0x1ee0f0,_0x32b2f7){const _0x4c4e59=_0x16899c;if(this[_0x4c4e59(0x281)]()){const _0x207958=Input[_0x4c4e59(0x20e)](_0x32b2f7)||[],_0x4bf0b3=_0x207958[_0x1ee0f0];if(TextManager['stringKeyMap'][_0x4bf0b3]===undefined)return'-';const _0x33d639=[TextManager[_0x4c4e59(0x387)][_0x4bf0b3]];return TextManager['makeInputButtonString'](_0x33d639);}else{if(this[_0x4c4e59(0x1eb)]()){const _0xc5225=Input[_0x4c4e59(0x26b)]();if(_0xc5225!=='Keyboard')return TextManager[_0x4c4e59(0x28b)](_0xc5225,_0x32b2f7);if(['up','left',_0x4c4e59(0x241),_0x4c4e59(0x351)][_0x4c4e59(0x291)](_0x32b2f7)){const _0x53c27e=TextManager[_0x4c4e59(0x383)][_0x4c4e59(0x36d)];return _0x53c27e[_0x4c4e59(0x3f5)](TextManager[_0x4c4e59(0x383)][_0x32b2f7]);}else{const _0x4152c4=TextManager[_0x4c4e59(0x383)][_0x4c4e59(0x359)];return _0x4152c4[_0x4c4e59(0x3f5)](Input['getGamepadButtonID'](_0x32b2f7));}}else return'';}},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x369)]=function(){const _0x33106d=_0x16899c;Window_Command['prototype'][_0x33106d(0x369)][_0x33106d(0x3d3)](this),this[_0x33106d(0x205)](),this[_0x33106d(0x25e)]();},Window_KeyRebinds[_0x16899c(0x2dd)]['updateShiftRemoveShortcut']=function(){const _0x7bcca8=_0x16899c;if(!this[_0x7bcca8(0x24a)]())return;if(!Input[_0x7bcca8(0x294)](_0x7bcca8(0x21e)))return;this[_0x7bcca8(0x281)]()&&this[_0x7bcca8(0x1f2)]()>=0x0&&SceneManager[_0x7bcca8(0x365)][_0x7bcca8(0x215)](this[_0x7bcca8(0x1f2)]()),this['isForGamepad']()&&SceneManager[_0x7bcca8(0x365)][_0x7bcca8(0x1f7)]();},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x25e)]=function(){const _0x58acae=_0x16899c;if(!this[_0x58acae(0x1eb)]())return;if(this[_0x58acae(0x3a0)]===Input['getLastUsedGamepadType']())return;this[_0x58acae(0x3a0)]=Input['getLastUsedGamepadType'](),this[_0x58acae(0x38e)]();},Window_KeyRebinds[_0x16899c(0x2dd)][_0x16899c(0x345)]=function(){const _0x4adc89=_0x16899c,_0x10e5c6=Window_KeyRebinds[_0x4adc89(0x21a)][_0x4adc89(0x35b)];this[_0x4adc89(0x3f2)][_0x4adc89(0x2c1)]();if(this[_0x4adc89(0x281)]())this[_0x4adc89(0x3f2)][_0x4adc89(0x26d)](_0x10e5c6[_0x4adc89(0x39e)]);else this[_0x4adc89(0x1eb)]()&&this[_0x4adc89(0x3f2)][_0x4adc89(0x26d)](_0x10e5c6['selectGamepad']);};